/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dwarven;

import de.hysky.skyblocker.annotations.RegisterWidget;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.dwarven.CrystalsLocationsManager;
import de.hysky.skyblocker.skyblock.dwarven.MiningLocationLabel;
import de.hysky.skyblocker.skyblock.tabhud.widget.HudWidget;
import de.hysky.skyblocker.utils.Location;
import java.util.List;
import java.util.Set;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.joml.Matrix3x2fStack;
import org.joml.Vector2i;
import org.joml.Vector2ic;

@RegisterWidget
public class CrystalsHudWidget
extends HudWidget {
    private static final class_310 CLIENT = class_310.method_1551();
    protected static final class_2960 MAP_TEXTURE = class_2960.method_60655((String)"skyblocker", (String)"textures/gui/crystals_map.png");
    private static final class_2960 MAP_ICON = class_2960.method_60656((String)"textures/map/decorations/player.png");
    private static final List<String> SMALL_LOCATIONS = List.of("Fairy Grotto", "King Yolkar", "Corleone", "Odawa", "Key Guardian", "Unknown");
    private static final Set<Location> AVAILABLE_LOCATIONS = Set.of(Location.CRYSTAL_HOLLOWS);
    private static CrystalsHudWidget instance = null;

    public static CrystalsHudWidget getInstance() {
        if (instance == null) {
            new CrystalsHudWidget();
        }
        return instance;
    }

    public CrystalsHudWidget() {
        super("hud_crystals");
        instance = this;
    }

    protected static Vector2ic transformLocation(double x, double z) {
        int transformedX = (int)((x - 202.0) / 621.0 * 62.0);
        int transformedY = (int)((z - 202.0) / 621.0 * 62.0);
        transformedX = Math.clamp((long)transformedX, 0, 62);
        transformedY = Math.clamp((long)transformedY, 0, 62);
        return new Vector2i(transformedX, transformedY);
    }

    private static float yaw2Cardinal(float yaw) {
        byte clipped = (byte)(((double)(yaw += 180.0f) + ((double)yaw < 0.0 ? -8.0 : 8.0)) * 16.0 / 360.0);
        return (float)clipped * 360.0f / 16.0f;
    }

    @Override
    public Set<Location> availableLocations() {
        return AVAILABLE_LOCATIONS;
    }

    @Override
    public boolean isEnabledIn(Location location) {
        return location.equals((Object)Location.CRYSTAL_HOLLOWS) && SkyblockerConfigManager.get().mining.crystalsHud.enabled;
    }

    @Override
    public void setEnabledIn(Location location, boolean enabled) {
        if (!location.equals((Object)Location.CRYSTAL_HOLLOWS)) {
            return;
        }
        SkyblockerConfigManager.get().mining.crystalsHud.enabled = enabled;
    }

    @Override
    public void update() {
        if (CrystalsHudWidget.CLIENT.field_1724 == null || CLIENT.method_1562() == null || !SkyblockerConfigManager.get().mining.crystalsHud.enabled) {
            return;
        }
        float scale = SkyblockerConfigManager.get().mining.crystalsHud.mapScaling;
        this.w = this.h = (int)(62.0f * scale);
    }

    @Override
    public void renderWidget(class_332 context, int mouseX, int mouseY, float delta) {
        float scale = SkyblockerConfigManager.get().mining.crystalsHud.mapScaling;
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        matrices.translate((float)this.x, (float)this.y);
        matrices.scale(scale, scale);
        this.w = this.h = (int)(62.0f * scale);
        context.method_25290(class_10799.field_56883, MAP_TEXTURE, 0, 0, 0.0f, 0.0f, 62, 62, 62, 62);
        if (SkyblockerConfigManager.get().mining.crystalsHud.showLocations) {
            for (MiningLocationLabel waypoint : CrystalsLocationsManager.activeWaypoints.values()) {
                MiningLocationLabel.Category category = waypoint.category();
                Vector2ic renderPos = CrystalsHudWidget.transformLocation(waypoint.centerPos.method_10216(), waypoint.centerPos.method_10215());
                int locationSize = SkyblockerConfigManager.get().mining.crystalsHud.locationSize;
                if (SMALL_LOCATIONS.contains(category.getName())) {
                    locationSize /= 2;
                }
                context.method_25294(renderPos.x() - locationSize / 2, renderPos.y() - locationSize / 2, renderPos.x() + locationSize / 2, renderPos.y() + locationSize / 2, category.getColor());
            }
        }
        if (CrystalsHudWidget.CLIENT.field_1724 == null || CLIENT.method_1562() == null) {
            matrices.popMatrix();
            return;
        }
        double playerX = CrystalsHudWidget.CLIENT.field_1724.method_23317();
        double playerZ = CrystalsHudWidget.CLIENT.field_1724.method_23321();
        float playerRotation = CrystalsHudWidget.CLIENT.field_1724.method_36454();
        Vector2ic renderPos = CrystalsHudWidget.transformLocation(playerX, playerZ);
        int renderX = renderPos.x() - 2;
        int renderY = renderPos.y() - 3;
        matrices.translate((float)renderX, (float)renderY);
        matrices.scale(0.75f, 0.75f);
        matrices.rotateAbout((float)Math.PI / 180 * CrystalsHudWidget.yaw2Cardinal(playerRotation), 2.5f, 3.5f);
        context.method_25290(class_10799.field_56883, MAP_ICON, 0, 0, 2.0f, 0.0f, 5, 7, 8, 8);
        matrices.popMatrix();
    }

    @Override
    public class_2561 getDisplayName() {
        return class_2561.method_30163((String)"Crystals HUD");
    }
}

