/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dwarven;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.RenderHelper;
import de.hysky.skyblocker.utils.waypoint.NamedWaypoint;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class MetalDetector {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final float[] LIGHT_GRAY = new float[]{0.7529412f, 0.7529412f, 0.7529412f};
    private static final Pattern TREASURE_PATTERN = Pattern.compile("(\u00a73\u00a7lTREASURE: \u00a7b)(\\d+\\.?\\d?)m");
    private static final Pattern KEEPER_PATTERN = Pattern.compile("Keeper of (\\w+)");
    private static final Map<String, class_2382> keeperOffsets = Map.of("Diamond", new class_2382(33, 0, 3), "Lapis", new class_2382(-33, 0, -3), "Emerald", new class_2382(-3, 0, 33), "Gold", new class_2382(3, 0, -33));
    private static final Set<class_2382> knownChestOffsets = Set.of(new class_2382(-38, -22, 26), new class_2382(38, -22, -26), new class_2382(-40, -22, 18), new class_2382(-41, -20, 22), new class_2382(-5, -21, 16), new class_2382(40, -22, -30), new class_2382(-42, -20, -28), new class_2382(-43, -22, -40), new class_2382(42, -19, -41), new class_2382(43, -21, -16), new class_2382(-1, -22, -20), new class_2382(6, -21, 28), new class_2382(7, -21, 11), new class_2382(7, -21, 22), new class_2382(-12, -21, -44), new class_2382(12, -22, 31), new class_2382(12, -22, -22), new class_2382(12, -21, 7), new class_2382(12, -21, -43), new class_2382(-14, -21, 43), new class_2382(-14, -21, 22), new class_2382(-17, -21, 20), new class_2382(-20, -22, 0), new class_2382(1, -21, 20), new class_2382(19, -22, 29), new class_2382(20, -22, 0), new class_2382(20, -21, -26), new class_2382(-23, -22, 40), new class_2382(22, -21, -14), new class_2382(-24, -22, 12), new class_2382(23, -22, 26), new class_2382(23, -22, -39), new class_2382(24, -22, 27), new class_2382(25, -22, 17), new class_2382(29, -21, -44), new class_2382(-31, -21, -12), new class_2382(-31, -21, -40), new class_2382(30, -21, -25), new class_2382(-32, -21, -40), new class_2382(-36, -20, 42), new class_2382(-37, -21, -14), new class_2382(-37, -21, -22));
    protected static class_2382 minesCenter = null;
    private static double previousDistance;
    private static class_243 previousPlayerPos;
    protected static boolean newTreasure;
    private static boolean startedLooking;
    protected static List<class_2382> possibleBlocks;

    @Init
    public static void init() {
        ClientReceiveMessageEvents.ALLOW_GAME.register(MetalDetector::getDistanceMessage);
        WorldRenderEvents.AFTER_TRANSLUCENT.register(MetalDetector::render);
        ClientPlayConnectionEvents.JOIN.register((_handler, _sender, _client) -> MetalDetector.reset());
    }

    private static boolean getDistanceMessage(class_2561 text, boolean overlay) {
        if (!(overlay && SkyblockerConfigManager.get().mining.crystalHollows.metalDetectorHelper && Utils.isInCrystalHollows() && Utils.getIslandArea().substring(2).equals("Mines of Divan") && MetalDetector.CLIENT.field_1724 != null)) {
            MetalDetector.checkChestFound(text);
            return true;
        }
        Matcher treasureDistanceMature = TREASURE_PATTERN.matcher(text.getString());
        if (!treasureDistanceMature.find()) {
            return true;
        }
        double distance = Double.parseDouble(treasureDistanceMature.group(2));
        class_243 playerPos = MetalDetector.CLIENT.field_1724.method_19538();
        int previousPossibleBlockCount = possibleBlocks.size();
        if (!startedLooking) {
            startedLooking = true;
            MetalDetector.CLIENT.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.dwarvenMines.metalDetectorHelper.startTip")), false);
        }
        if (minesCenter == null) {
            MetalDetector.findCenterOfMines();
        }
        if (distance == previousDistance && playerPos.equals((Object)previousPlayerPos)) {
            MetalDetector.updatePossibleBlocks(distance, playerPos);
        }
        if (possibleBlocks.size() != previousPossibleBlockCount) {
            if (possibleBlocks.size() == 1) {
                MetalDetector.CLIENT.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.dwarvenMines.metalDetectorHelper.foundTreasureMessage").method_27692(class_124.field_1060)), false);
            } else {
                MetalDetector.CLIENT.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.dwarvenMines.metalDetectorHelper.possibleTreasureLocationsMessage").method_10852(class_2561.method_30163((String)String.valueOf(possibleBlocks.size())))), false);
            }
        }
        previousDistance = distance;
        previousPlayerPos = playerPos;
        return true;
    }

    private static void checkChestFound(class_2561 text) {
        if (!Utils.isInCrystalHollows() || !Utils.getIslandArea().substring(2).equals("Mines of Divan") || MetalDetector.CLIENT.field_1724 == null) {
            return;
        }
        if (text.getString().startsWith("You found")) {
            newTreasure = true;
            possibleBlocks = new ArrayList<class_2382>();
        }
    }

    protected static void updatePossibleBlocks(double distance, class_243 playerPos) {
        if (newTreasure) {
            possibleBlocks = new ArrayList<class_2382>();
            newTreasure = false;
            if (minesCenter != null) {
                for (class_2382 knownOffset : knownChestOffsets) {
                    class_2382 checkPos = minesCenter.method_35853(knownOffset).method_34592(0, 1, 0);
                    if (!(Math.abs(playerPos.method_1022(class_243.method_24954((class_2382)checkPos)) - distance) < 0.25)) continue;
                    possibleBlocks.add(checkPos);
                }
            } else {
                int x = (int)(-distance);
                while ((double)x <= distance) {
                    int z = (int)(-distance);
                    while ((double)z <= distance) {
                        class_2382 checkPos = new class_2382((int)playerPos.field_1352 + x, (int)playerPos.field_1351, (int)playerPos.field_1350 + z);
                        if (Math.abs(playerPos.method_1022(class_243.method_24954((class_2382)checkPos)) - distance) < 0.25) {
                            possibleBlocks.add(checkPos);
                        }
                        ++z;
                    }
                    ++x;
                }
            }
        } else {
            possibleBlocks.removeIf(location -> Math.abs(playerPos.method_1022(class_243.method_24954((class_2382)location)) - distance) >= 0.25);
        }
        if (possibleBlocks.isEmpty()) {
            newTreasure = true;
            if (MetalDetector.CLIENT.field_1724 != null) {
                MetalDetector.CLIENT.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.dwarvenMines.metalDetectorHelper.somethingWentWrongMessage").method_27692(class_124.field_1061)), false);
            }
        }
    }

    private static void findCenterOfMines() {
        if (MetalDetector.CLIENT.field_1724 == null || MetalDetector.CLIENT.field_1687 == null) {
            return;
        }
        class_238 searchBox = MetalDetector.CLIENT.field_1724.method_5829().method_1014(500.0);
        List armorStands = MetalDetector.CLIENT.field_1687.method_8390(class_1531.class, searchBox, class_1297::method_16914);
        for (class_1531 armorStand : armorStands) {
            String name = armorStand.method_5477().getString();
            Matcher nameMatcher = KEEPER_PATTERN.matcher(name);
            if (!nameMatcher.matches()) continue;
            class_2382 offset = keeperOffsets.get(nameMatcher.group(1));
            minesCenter = armorStand.method_24515().method_10081(offset);
            MetalDetector.CLIENT.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.dwarvenMines.metalDetectorHelper.foundCenter").method_27692(class_124.field_1060)), false);
            return;
        }
    }

    private static void reset() {
        minesCenter = null;
        possibleBlocks = new ArrayList<class_2382>();
    }

    private static void render(WorldRenderContext context) {
        if (!SkyblockerConfigManager.get().mining.crystalHollows.metalDetectorHelper || !Utils.isInCrystalHollows() || possibleBlocks.isEmpty() || possibleBlocks.size() > 8 || !Utils.getIslandArea().substring(2).equals("Mines of Divan")) {
            return;
        }
        if (possibleBlocks.size() == 1) {
            class_2382 block = possibleBlocks.getFirst().method_34592(0, -1, 0);
            NamedWaypoint waypoint = new NamedWaypoint(new class_2338(block.method_10263(), block.method_10264(), block.method_10260()), class_2561.method_43471((String)"skyblocker.dwarvenMines.metalDetectorHelper.treasure").getString(), Color.yellow.getColorComponents(null));
            waypoint.render(context);
            RenderHelper.renderLineFromCursor(context, class_243.method_24953((class_2382)block), LIGHT_GRAY, 1.0f, 5.0f);
            return;
        }
        for (class_2382 block : possibleBlocks) {
            NamedWaypoint waypoint = new NamedWaypoint(new class_2338(block.method_10263(), block.method_10264(), block.method_10260()), class_2561.method_43471((String)"skyblocker.dwarvenMines.metalDetectorHelper.possible").getString(), Color.white.getColorComponents(null));
            waypoint.render(context);
        }
    }

    static {
        newTreasure = true;
        startedLooking = false;
        possibleBlocks = new ArrayList<class_2382>();
    }
}

