/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dwarven;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.RenderHelper;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NucleusWaypoints {
    private static final Logger LOGGER = LoggerFactory.getLogger(NucleusWaypoints.class);
    private static final List<Waypoint> WAYPOINTS = List.of(new Waypoint(new class_2338(551, 116, 551), "Precursor Remnants", class_1767.field_7951), new Waypoint(new class_2338(551, 116, 475), "Mithril Deposits", class_1767.field_7961), new Waypoint(new class_2338(475, 116, 551), "Goblin Holdout", class_1767.field_7946), new Waypoint(new class_2338(475, 116, 475), "Jungle", class_1767.field_7945), new Waypoint(new class_2338(513, 106, 524), "Nucleus", class_1767.field_7964));

    public static void render(WorldRenderContext context) {
        try {
            boolean enabled = SkyblockerConfigManager.get().mining.crystalHollows.nucleusWaypoints;
            boolean inCrystalHollows = Utils.isInCrystalHollows();
            if (enabled && inCrystalHollows) {
                for (Waypoint waypoint : WAYPOINTS) {
                    int rgb = waypoint.color.method_7790();
                    class_5251 textColor = class_5251.method_27717((int)rgb);
                    class_5250 text = class_2561.method_43470((String)waypoint.name).method_10862(class_2583.field_24360.method_27703(textColor));
                    RenderHelper.renderText(context, (class_2561)text, waypoint.position.method_46558().method_1031(0.0, 5.0, 0.0), 8.0f, true);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[{}] Error occurred while rendering Nucleus waypoints. {}", (Object)LOGGER.getName(), (Object)e);
        }
    }

    private static class Waypoint {
        class_2338 position;
        String name;
        class_1767 color;

        Waypoint(class_2338 position, String name, class_1767 color) {
            this.position = position;
            this.name = name;
            this.color = color;
        }
    }
}

