/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.experiment;

import de.hysky.skyblocker.config.configs.HelperConfig;
import de.hysky.skyblocker.skyblock.experiment.ExperimentSolver;
import de.hysky.skyblocker.utils.render.gui.ColorHighlight;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1707;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_476;

public final class ChronomatronSolver
extends ExperimentSolver {
    public static final Object2ObjectMap<class_1792, class_1792> TERRACOTTA_TO_GLASS = Object2ObjectMaps.unmodifiable((Object2ObjectMap)new Object2ObjectArrayMap((Object[])new class_1792[]{class_1802.field_8353, class_1802.field_8043, class_1802.field_8385, class_1802.field_8672, class_1802.field_8798, class_1802.field_8821, class_1802.field_8717, class_1802.field_8455, class_1802.field_8715, class_1802.field_8853}, (Object[])new class_1792[]{class_1802.field_8636, class_1802.field_8393, class_1802.field_8095, class_1802.field_8340, class_1802.field_8734, class_1802.field_8685, class_1802.field_8869, class_1802.field_8126, class_1802.field_8838, class_1802.field_8770}));
    private final List<class_1792> chronomatronSlots = new ArrayList<class_1792>();
    private int chronomatronChainLengthCount;
    private int chronomatronCurrentSlot;
    private int chronomatronCurrentOrdinal;

    public ChronomatronSolver() {
        super("^Chronomatron \\(\\w+\\)$");
    }

    @Override
    protected boolean isEnabled(HelperConfig.Experiments experimentsConfig) {
        return experimentsConfig.enableChronomatronSolver;
    }

    @Override
    protected void tick(class_476 screen) {
        switch (this.getState()) {
            case REMEMBER: {
                class_1263 inventory = ((class_1707)screen.method_17577()).method_7629();
                if (this.chronomatronCurrentSlot == 0) {
                    for (int index = 10; index < 43; ++index) {
                        if (!inventory.method_5438(index).method_7958()) continue;
                        if (this.chronomatronSlots.size() <= this.chronomatronChainLengthCount) {
                            this.chronomatronSlots.add((class_1792)TERRACOTTA_TO_GLASS.get((Object)inventory.method_5438(index).method_7909()));
                            this.setState(ExperimentSolver.State.WAIT);
                        } else {
                            ++this.chronomatronChainLengthCount;
                        }
                        this.chronomatronCurrentSlot = index;
                        return;
                    }
                    break;
                }
                if (inventory.method_5438(this.chronomatronCurrentSlot).method_7958()) break;
                this.chronomatronCurrentSlot = 0;
                break;
            }
            case WAIT: {
                if (!((class_1707)screen.method_17577()).method_7629().method_5438(49).method_7964().getString().startsWith("Timer: ")) break;
                this.setState(ExperimentSolver.State.SHOW);
                break;
            }
            case END: {
                String name = ((class_1707)screen.method_17577()).method_7629().method_5438(49).method_7964().getString();
                if (name.startsWith("Timer: ")) break;
                if (name.equals("Remember the pattern!")) {
                    this.chronomatronChainLengthCount = 0;
                    this.chronomatronCurrentOrdinal = 0;
                    this.setState(ExperimentSolver.State.REMEMBER);
                    break;
                }
                this.reset();
            }
        }
    }

    @Override
    public List<ColorHighlight> getColors(Int2ObjectMap<class_1799> slots) {
        ArrayList<ColorHighlight> highlights = new ArrayList<ColorHighlight>();
        if (this.getState() == ExperimentSolver.State.SHOW && this.chronomatronSlots.size() > this.chronomatronCurrentOrdinal) {
            for (Int2ObjectMap.Entry indexStack : slots.int2ObjectEntrySet()) {
                class_1792 item;
                int index = indexStack.getIntKey();
                class_1799 stack = (class_1799)indexStack.getValue();
                if (!stack.method_31574(item = this.chronomatronSlots.get(this.chronomatronCurrentOrdinal)) && TERRACOTTA_TO_GLASS.get((Object)stack.method_7909()) != item) continue;
                highlights.add(ColorHighlight.green(index));
            }
        }
        return highlights;
    }

    @Override
    public boolean onClickSlot(int slot, class_1799 stack, int screenId, int button) {
        if (this.getState() == ExperimentSolver.State.SHOW) {
            class_1792 item = this.chronomatronSlots.get(this.chronomatronCurrentOrdinal);
            if (stack.method_31574(item) || TERRACOTTA_TO_GLASS.get((Object)stack.method_7909()) == item) {
                if (++this.chronomatronCurrentOrdinal >= this.chronomatronSlots.size()) {
                    this.setState(ExperimentSolver.State.END);
                }
            } else {
                return this.shouldBlockIncorrectClicks();
            }
        }
        return super.onClickSlot(slot, stack, screenId, button);
    }

    @Override
    public void reset() {
        this.chronomatronSlots.clear();
        this.chronomatronChainLengthCount = 0;
        this.chronomatronCurrentSlot = 0;
        this.chronomatronCurrentOrdinal = 0;
        super.reset();
    }
}

