/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.fancybars;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.UIAndVisualsConfig;
import de.hysky.skyblocker.skyblock.StatusBarTracker;
import de.hysky.skyblocker.skyblock.fancybars.BarPositioner;
import de.hysky.skyblocker.skyblock.fancybars.StatusBarType;
import de.hysky.skyblocker.utils.render.HudHelper;
import java.awt.Color;
import java.lang.runtime.SwitchBootstraps;
import java.util.function.Consumer;
import net.minecraft.class_1074;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3542;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.Nullable;

public class StatusBar
implements class_8021,
class_4068,
class_364,
class_6379 {
    private static final class_2960 BAR_FILL = class_2960.method_60655((String)"skyblocker", (String)"bars/bar_fill");
    private static final class_2960 BAR_BACK = class_2960.method_60655((String)"skyblocker", (String)"bars/bar_back");
    public static final int ICON_SIZE = 9;
    private final class_2960 icon;
    private final StatusBarType type;
    private Color[] colors;
    @Nullable
    private Color textColor;
    @Nullable
    private OnClick onClick = null;
    public int gridX = 0;
    public int gridY = 0;
    public float x = 0.0f;
    public float y = 0.0f;
    public float width = 0.0f;
    @Nullable
    public BarPositioner.BarAnchor anchor = null;
    public int size = 1;
    public float fill = 0.0f;
    public float overflowFill = 0.0f;
    public boolean inMouse = false;
    public boolean visible = true;
    public boolean enabled = true;
    private Object value = "???";
    @Nullable
    private Object max = "???";
    @Nullable
    private Object overflow = "???";
    private int renderX = 0;
    private int renderY = 0;
    private int renderWidth = 0;
    private IconPosition iconPosition = IconPosition.LEFT;
    private TextPosition textPosition = TextPosition.BAR_CENTER;
    public boolean showMax = false;
    public boolean showOverflow = false;

    public Color[] getColors() {
        return this.colors;
    }

    public boolean hasOverflow() {
        return this.type.hasOverflow();
    }

    public boolean hasMax() {
        return this.type.hasMax();
    }

    @Nullable
    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(@Nullable Color textColor) {
        this.textColor = textColor;
    }

    public class_2561 getName() {
        return this.type.getName();
    }

    public StatusBar(StatusBarType type) {
        this.icon = class_2960.method_60655((String)"skyblocker", (String)("bars/icons/" + type.method_15434()));
        this.colors = type.getColors();
        this.textColor = type.getTextColor();
        this.type = type;
    }

    protected int transparency(int color) {
        if (this.inMouse) {
            return color & 0xFFFFFF | 0x44000000;
        }
        return color;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.renderWidth <= 0) {
            return;
        }
        int transparency = this.transparency(-1);
        switch (this.iconPosition.ordinal()) {
            case 0: {
                context.method_52707(class_10799.field_56883, this.icon, this.renderX, this.renderY, 9, 9, transparency);
                break;
            }
            case 1: {
                context.method_52707(class_10799.field_56883, this.icon, this.renderX + this.renderWidth - 9, this.renderY, 9, 9, transparency);
            }
        }
        int barWidth = this.iconPosition.equals((Object)IconPosition.OFF) ? this.renderWidth : this.renderWidth - 9 - 1;
        int barX = this.iconPosition.equals((Object)IconPosition.LEFT) ? this.renderX + 9 + 1 : this.renderX;
        context.method_52707(class_10799.field_56883, BAR_BACK, barX, this.renderY + 1, barWidth, 7, transparency);
        this.drawBarFill(context, barX, barWidth);
        if (this.showText() && this.enabled) {
            this.renderText(context);
        }
    }

    protected void drawBarFill(class_332 context, int barX, int barWith) {
        HudHelper.renderNineSliceColored(context, BAR_FILL, barX + 1, this.renderY + 2, (int)((float)(barWith - 2) * this.fill), 5, this.transparency(this.colors[0].getRGB()));
        if (this.hasOverflow() && this.overflowFill > 0.0f) {
            HudHelper.renderNineSliceColored(context, BAR_FILL, barX + 1, this.renderY + 2, (int)((float)(barWith - 2) * Math.min(this.overflowFill, 1.0f)), 5, this.transparency(this.colors[1].getRGB()));
        }
    }

    public void updateValues(float fill, float overflowFill, Object text, @Nullable Object max, @Nullable Object overflow) {
        this.value = text;
        this.fill = fill;
        this.overflowFill = overflowFill;
        this.max = max;
        this.overflow = overflow;
    }

    public void updateWithResource(StatusBarTracker.Resource resource) {
        this.updateValues((float)resource.value() / (float)resource.max(), (float)resource.overflow() / (float)resource.max(), resource.value(), resource.max(), resource.overflow() > 0 ? Integer.valueOf(resource.overflow()) : null);
    }

    public void renderText(class_332 context) {
        if (!this.showText()) {
            return;
        }
        class_327 textRenderer = class_310.method_1551().field_1772;
        int barWidth = this.iconPosition.equals((Object)IconPosition.OFF) ? this.renderWidth : this.renderWidth - 9 - 1;
        int barX = this.iconPosition.equals((Object)IconPosition.LEFT) ? this.renderX + 9 + 2 : this.renderX;
        String stringValue = this.value.toString();
        class_5250 text = class_2561.method_43470((String)stringValue).method_27694(style -> style.method_36139((this.textColor == null ? this.colors[0] : this.textColor).getRGB()));
        if (this.hasMax() && this.showMax && this.max != null) {
            text.method_27693("/").method_27693(this.max.toString());
        }
        if (this.hasOverflow() && this.showOverflow && this.overflow != null) {
            class_5250 literal = class_2561.method_43470((String)" + ").method_27694(style -> style.method_36139(this.colors[1].getRGB()));
            literal.method_27693(this.overflow.toString());
            text.method_10852((class_2561)literal);
        }
        int textWidth = textRenderer.method_27525((class_5348)text);
        TextPosition textPosition = this.textPosition;
        int n = 0;
        int x = switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"RIGHT", "CENTER", "BAR_CENTER"}, (TextPosition)textPosition, n)) {
            case 0 -> barX + barWidth - textWidth;
            case 1 -> this.renderX + (this.renderWidth - textWidth) / 2;
            case 2 -> barX + (barWidth - textWidth) / 2;
            default -> barX;
        };
        int y = this.renderY - 3;
        int color = this.transparency((this.textColor == null ? this.colors[0] : this.textColor).getRGB());
        int outlineColor = this.transparency(-16777216);
        HudHelper.drawOutlinedText(context, class_2561.method_54155((Message)text).method_30937(), x, y, color, outlineColor);
    }

    public void renderCursor(class_332 context, int mouseX, int mouseY, float delta) {
        int temp_x = this.renderX;
        int temp_y = this.renderY;
        boolean temp_ghost = this.inMouse;
        this.renderX = mouseX;
        this.renderY = mouseY;
        this.inMouse = false;
        this.method_25394(context, mouseX, mouseY, delta);
        this.renderX = temp_x;
        this.renderY = temp_y;
        this.inMouse = temp_ghost;
    }

    public void method_46421(int x) {
        this.renderX = x;
    }

    public void method_46419(int y) {
        this.renderY = y;
    }

    public int method_46426() {
        return this.renderX;
    }

    public int method_46427() {
        return this.renderY;
    }

    public int method_25368() {
        return this.renderWidth;
    }

    public void setWidth(int width) {
        this.renderWidth = width;
    }

    public int method_25364() {
        return 9;
    }

    public class_8030 method_48202() {
        return super.method_48202();
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= (double)this.renderX && mouseX <= (double)(this.renderX + this.method_25368()) && mouseY >= (double)this.renderY && mouseY <= (double)(this.renderY + this.method_25364());
    }

    public void method_48206(Consumer<class_339> consumer) {
    }

    public void method_25365(boolean focused) {
    }

    public boolean method_25370() {
        return false;
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        if (this.onClick != null) {
            this.onClick.onClick(this, button, (int)mouseX, (int)mouseY);
        }
        return true;
    }

    public void setOnClick(@Nullable OnClick onClick) {
        this.onClick = onClick;
    }

    public void method_37020(class_6382 builder) {
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.getName()).append("gridX", this.gridX).append("gridY", this.gridY).append("size", this.size).append("x", this.renderX).append("y", this.renderY).append("width", this.renderWidth).append("anchor", (Object)this.anchor).toString();
    }

    public IconPosition getIconPosition() {
        return this.iconPosition;
    }

    public void setIconPosition(IconPosition iconPosition) {
        this.iconPosition = iconPosition;
    }

    public boolean showText() {
        return this.textPosition != TextPosition.OFF;
    }

    public TextPosition getTextPosition() {
        return this.textPosition;
    }

    public void setTextPosition(TextPosition textPosition) {
        this.textPosition = textPosition;
    }

    public void loadFromJson(JsonObject object) {
        String maybeAnchor;
        if (object.has("colors")) {
            JsonArray colors1 = object.get("colors").getAsJsonArray();
            if (colors1.size() < 2 && this.hasOverflow()) {
                throw new IllegalStateException("Missing second color of bar that has overflow");
            }
            Color[] newColors = new Color[colors1.size()];
            for (int i = 0; i < colors1.size(); ++i) {
                JsonElement jsonElement = colors1.get(i);
                newColors[i] = new Color(Integer.parseInt(jsonElement.getAsString(), 16));
            }
            this.colors = newColors;
        }
        if (object.has("text_color")) {
            this.textColor = new Color(Integer.parseInt(object.get("text_color").getAsString(), 16));
        }
        BarPositioner.BarAnchor barAnchor = this.anchor = (maybeAnchor = object.get("anchor").getAsString().trim()).equals("null") ? null : BarPositioner.BarAnchor.valueOf(maybeAnchor);
        this.enabled = !object.has("enabled") ? this.anchor != null : object.get("enabled").getAsBoolean();
        if (this.anchor != null) {
            this.size = object.get("size").getAsInt();
            this.gridX = object.get("x").getAsInt();
            this.gridY = object.get("y").getAsInt();
        } else {
            this.width = object.get("size").getAsFloat();
            this.x = object.get("x").getAsFloat();
            this.y = object.get("y").getAsFloat();
        }
        if (object.has("icon_position")) {
            this.iconPosition = IconPosition.valueOf(object.get("icon_position").getAsString().trim());
        }
        if (object.has("show_text")) {
            TextPosition textPosition = this.textPosition = object.get("show_text").getAsBoolean() ? TextPosition.BAR_CENTER : TextPosition.OFF;
        }
        if (object.has("text_position")) {
            this.textPosition = TextPosition.valueOf(object.get("text_position").getAsString().trim());
        }
        if (object.has("show_max")) {
            this.showMax = object.get("show_max").getAsBoolean();
        }
        if (object.has("show_overflow")) {
            this.showOverflow = object.get("show_overflow").getAsBoolean();
        }
    }

    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        JsonArray colors1 = new JsonArray();
        for (Color color : this.colors) {
            colors1.add(Integer.toHexString(color.getRGB()).substring(2));
        }
        object.add("colors", (JsonElement)colors1);
        if (this.textColor != null) {
            object.addProperty("text_color", Integer.toHexString(this.textColor.getRGB()).substring(2));
        }
        if (this.anchor != null) {
            object.addProperty("anchor", this.anchor.toString());
        } else {
            object.addProperty("anchor", "null");
        }
        if (this.anchor != null) {
            object.addProperty("x", (Number)this.gridX);
            object.addProperty("y", (Number)this.gridY);
            object.addProperty("size", (Number)this.size);
        } else {
            object.addProperty("size", (Number)Float.valueOf(this.width));
            object.addProperty("x", (Number)Float.valueOf(this.x));
            object.addProperty("y", (Number)Float.valueOf(this.y));
        }
        object.addProperty("icon_position", this.iconPosition.method_15434());
        object.addProperty("text_position", this.textPosition.method_15434());
        object.addProperty("show_max", Boolean.valueOf(this.showMax));
        object.addProperty("show_overflow", Boolean.valueOf(this.showOverflow));
        object.addProperty("enabled", Boolean.valueOf(this.enabled));
        return object;
    }

    @FunctionalInterface
    public static interface OnClick {
        public void onClick(StatusBar var1, int var2, int var3, int var4);
    }

    public static enum IconPosition implements class_3542
    {
        LEFT,
        RIGHT,
        OFF;


        public String method_15434() {
            return this.name();
        }

        public String toString() {
            return class_1074.method_4662((String)("skyblocker.bars.config.commonPosition." + this.name()), (Object[])new Object[0]);
        }
    }

    public static enum TextPosition implements class_3542
    {
        LEFT,
        CENTER,
        BAR_CENTER,
        RIGHT,
        OFF;


        public String method_15434() {
            return this.name();
        }

        public String toString() {
            if (this == CENTER || this == BAR_CENTER) {
                return class_1074.method_4662((String)("skyblocker.bars.config.textPosition." + this.name()), (Object[])new Object[0]);
            }
            return class_1074.method_4662((String)("skyblocker.bars.config.commonPosition." + this.name()), (Object[])new Object[0]);
        }
    }

    public static class ManaStatusBar
    extends StatusBar {
        public ManaStatusBar(StatusBarType type) {
            super(type);
        }

        @Override
        protected void drawBarFill(class_332 context, int barX, int barWith) {
            if (this.hasOverflow() && this.overflowFill > 0.0f) {
                if (this.overflowFill > this.fill && SkyblockerConfigManager.get().uiAndVisuals.bars.intelligenceDisplay == UIAndVisualsConfig.IntelligenceDisplay.IN_FRONT) {
                    HudHelper.renderNineSliceColored(context, BAR_FILL, barX + 1, this.method_46427() + 2, (int)((float)(barWith - 2) * Math.min(this.overflowFill, 1.0f)), 5, this.transparency(this.getColors()[1].getRGB()));
                    HudHelper.renderNineSliceColored(context, BAR_FILL, barX + 1, this.method_46427() + 2, (int)((float)(barWith - 2) * this.fill), 5, this.transparency(this.getColors()[0].getRGB()));
                } else {
                    HudHelper.renderNineSliceColored(context, BAR_FILL, barX + 1, this.method_46427() + 2, (int)((float)(barWith - 2) * this.fill), 5, this.transparency(this.getColors()[0].getRGB()));
                    HudHelper.renderNineSliceColored(context, BAR_FILL, barX + 1, this.method_46427() + 2, (int)((float)(barWith - 2) * Math.min(this.overflowFill, 1.0f)), 5, this.transparency(this.getColors()[1].getRGB()));
                }
            } else {
                HudHelper.renderNineSliceColored(context, BAR_FILL, barX + 1, this.method_46427() + 2, (int)((float)(barWith - 2) * this.fill), 5, this.transparency(this.getColors()[0].getRGB()));
            }
        }
    }
}

