/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.fishing;

import de.hysky.skyblocker.annotations.RegisterWidget;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.HelperConfig;
import de.hysky.skyblocker.skyblock.PetCache;
import de.hysky.skyblocker.skyblock.fishing.FishingHelper;
import de.hysky.skyblocker.skyblock.fishing.FishingHookDisplayHelper;
import de.hysky.skyblocker.skyblock.fishing.SeaCreatureTracker;
import de.hysky.skyblocker.skyblock.item.PetInfo;
import de.hysky.skyblocker.skyblock.profileviewer.utils.LevelFinder;
import de.hysky.skyblocker.skyblock.tabhud.config.WidgetsConfigurationScreen;
import de.hysky.skyblocker.skyblock.tabhud.util.Ico;
import de.hysky.skyblocker.skyblock.tabhud.widget.ComponentBasedWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.Components;
import de.hysky.skyblocker.utils.ColorUtils;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.SkyblockTime;
import de.hysky.skyblocker.utils.Utils;
import it.unimi.dsi.fastutil.objects.ObjectFloatPair;
import java.lang.invoke.StringConcatFactory;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;

@RegisterWidget
public class FishingHudWidget
extends ComponentBasedWidget {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final class_243 BARN_LOCATION = new class_243(108.0, 89.0, -252.0);
    private static FishingHudWidget instance;

    public static FishingHudWidget getInstance() {
        return instance;
    }

    public FishingHudWidget() {
        super(class_2561.method_43470((String)"Fishing").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067}), class_124.field_1062.method_532(), "hud_fishing");
        instance = this;
    }

    @Override
    public boolean shouldUpdateBeforeRendering() {
        return true;
    }

    @Override
    public Set<Location> availableLocations() {
        return ALL_LOCATIONS;
    }

    @Override
    public void setEnabledIn(Location location, boolean enabled) {
        SkyblockerConfigManager.get().helpers.fishing.enableFishingHud = enabled;
    }

    @Override
    public boolean isEnabledIn(Location location) {
        return SkyblockerConfigManager.get().helpers.fishing.enableFishingHud;
    }

    @Override
    public boolean shouldRender(Location location) {
        if (!super.shouldRender(location)) {
            return false;
        }
        if (SkyblockerConfigManager.get().helpers.fishing.enableSeaCreatureCounter && SeaCreatureTracker.isCreaturesAlive().booleanValue()) {
            if (Utils.getLocation() == Location.HUB && SkyblockerConfigManager.get().helpers.fishing.onlyShowHudInBarn) {
                return FishingHudWidget.isBarnFishing();
            }
            return true;
        }
        if (SkyblockerConfigManager.get().helpers.fishing.enableFishingTimer && FishingHelper.startTime != 0L) {
            return true;
        }
        return SkyblockerConfigManager.get().helpers.fishing.fishingHookDisplay == HelperConfig.Fishing.FishingHookDisplay.HUD && FishingHookDisplayHelper.fishingHookArmorStand != null;
    }

    @Override
    public void updateContent() {
        if (class_310.method_1551().field_1755 instanceof WidgetsConfigurationScreen) {
            this.addComponent(Components.progressComponent(Ico.SALMON_BUCKET, class_2561.method_30163((String)"Alive Creatures"), class_2561.method_30163((String)"3/5"), 60.0f, ColorUtils.percentToColor(40.0f)));
            this.addComponent(Components.progressComponent(Ico.CLOCK, class_2561.method_30163((String)"Time Left"), class_2561.method_30163((String)"1m"), 60.0f / (float)SkyblockerConfigManager.get().helpers.fishing.timerLength * 100.0f));
            return;
        }
        if (SkyblockerConfigManager.get().helpers.fishing.enableSeaCreatureCounter && SeaCreatureTracker.isCreaturesAlive().booleanValue()) {
            ObjectFloatPair<class_2561> timer = SeaCreatureTracker.getTimerText(SeaCreatureTracker.getOldestSeaCreatureAge());
            int seaCreatureCap = SeaCreatureTracker.getSeaCreatureCap();
            float seaCreaturePercent = (float)SeaCreatureTracker.seaCreatureCount() / (float)seaCreatureCap * 100.0f;
            this.addComponent(Components.progressComponent(Ico.TROPICAL_FISH_BUCKET, class_2561.method_30163((String)"Alive Creatures"), class_2561.method_30163((String)(SeaCreatureTracker.seaCreatureCount() + "/" + seaCreatureCap)), seaCreaturePercent, ColorUtils.percentToColor(100.0f - seaCreaturePercent)));
            this.addComponent(Components.progressComponent(Ico.CLOCK, class_2561.method_30163((String)"Time Left"), (class_2561)timer.left(), timer.rightFloat()));
        }
        if (SkyblockerConfigManager.get().helpers.fishing.enableFishingTimer && FishingHelper.startTime != 0L) {
            float maxTime;
            float time = Math.round((float)(System.currentTimeMillis() - FishingHelper.startTime) / 1000.0f);
            PetInfo pet = PetCache.getCurrentPet();
            if (pet != null && pet.type().contains("SLUG")) {
                int level = LevelFinder.getLevelInfo((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"PET_\u0001"}, (String)String.valueOf((Object)((Object)pet.tier())))), (long)((long)pet.exp())).level;
                maxTime = 20.0f * (1.0f - (float)level / 200.0f);
            } else {
                maxTime = 20.0f;
            }
            time = Math.clamp(time, 0.0f, maxTime);
            this.addComponent(Components.progressComponent(Ico.CLOCK, class_2561.method_30163((String)"Bobber Time"), (class_2561)SkyblockTime.formatTime(maxTime - time), 100.0f - time / maxTime * 100.0f));
        }
        if (SkyblockerConfigManager.get().helpers.fishing.fishingHookDisplay == HelperConfig.Fishing.FishingHookDisplay.HUD && FishingHookDisplayHelper.fishingHookArmorStand != null) {
            String rodReelTimer = FishingHookDisplayHelper.fishingHookArmorStand.method_5477().getString();
            this.addSimpleIcoText(Ico.CLOCK, "Reel Timer: ", rodReelTimer.equals("!!!") ? class_124.field_1061 : class_124.field_1054, rodReelTimer);
        }
    }

    @Override
    public class_2561 getDisplayName() {
        return class_2561.method_43470((String)"Fishing Hud");
    }

    private static boolean isBarnFishing() {
        return FishingHudWidget.CLIENT.field_1724 != null && FishingHudWidget.CLIENT.field_1724.method_5707(BARN_LOCATION) < 2500.0;
    }
}

