/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.fishing;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.ChatEvents;
import de.hysky.skyblocker.skyblock.fishing.SeaCreature;
import de.hysky.skyblocker.skyblock.item.SkyblockItemRarity;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.SkyblockTime;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.title.Title;
import de.hysky.skyblocker.utils.render.title.TitleContainer;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import it.unimi.dsi.fastutil.objects.ObjectFloatPair;
import java.util.LinkedHashMap;
import java.util.SequencedMap;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.class_638;

public class SeaCreatureTracker {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final Pattern DOUBLE_HOOK_PATTERN = Pattern.compile("Double Hook!(?: Woot woot!)?");
    private static final SequencedMap<class_1297, LiveSeaCreature> seaCreatures = new LinkedHashMap<class_1297, LiveSeaCreature>();
    private static SeaCreature lastCatch;
    private static boolean doubleHook;

    @Init
    public static void init() {
        ChatEvents.RECEIVE_STRING.register(SeaCreatureTracker::onChatMessage);
        ClientEntityEvents.ENTITY_UNLOAD.register(SeaCreatureTracker::onEntityDespawn);
    }

    private static void onEntityDespawn(class_1297 entity, class_638 clientWorld) {
        seaCreatures.remove(entity);
    }

    public static void onEntitySpawn(class_1531 armorStand) {
        if (!(armorStand.method_5767() && armorStand.method_16914() && armorStand.method_5807() && lastCatch != null)) {
            return;
        }
        if (armorStand.method_5477().getString().contains(SeaCreatureTracker.lastCatch.name)) {
            seaCreatures.put((class_1297)armorStand, new LiveSeaCreature(lastCatch, (class_1297)armorStand, System.currentTimeMillis()));
            if (doubleHook) {
                doubleHook = false;
            } else {
                lastCatch = null;
            }
            SeaCreatureTracker.checkCapNotification();
            SeaCreatureTracker.checkRarityNotification();
            Scheduler.INSTANCE.schedule(SeaCreatureTracker::checkTimerNotification, SkyblockerConfigManager.get().helpers.fishing.timerLength * 20);
        }
    }

    private static void checkTimerNotification() {
        if (!SkyblockerConfigManager.get().helpers.fishing.seaCreatureTimerNotification || !SeaCreatureTracker.isCreaturesAlive().booleanValue()) {
            return;
        }
        if (Math.abs((long)SkyblockerConfigManager.get().helpers.fishing.timerLength * 1000L - SeaCreatureTracker.getOldestSeaCreatureAge()) < 100L) {
            TitleContainer.addTitle(new Title(class_2561.method_43471((String)"skyblocker.config.helpers.fishing.seaCreatureTimerNotification.notification").method_27692(class_124.field_1061)), 60);
            if (SeaCreatureTracker.CLIENT.field_1724 == null) {
                return;
            }
            SeaCreatureTracker.CLIENT.field_1724.method_5783(class_3417.field_15224, 100.0f, 0.1f);
        }
    }

    private static void checkRarityNotification() {
        SkyblockItemRarity rarityThreshold = SkyblockerConfigManager.get().helpers.fishing.minimumNotificationRarity;
        if (rarityThreshold == SkyblockItemRarity.UNKNOWN) {
            return;
        }
        SeaCreature lastCreature = SeaCreatureTracker.seaCreatures.sequencedValues().getLast().seaCreature;
        SkyblockItemRarity lastCreatureRarity = lastCreature.rarity;
        if (lastCreatureRarity.compareTo(rarityThreshold) >= 0) {
            TitleContainer.addTitle(new Title(class_2561.method_43470((String)lastCreature.name).method_27692(lastCreatureRarity.formatting)), 60);
            if (SeaCreatureTracker.CLIENT.field_1724 == null) {
                return;
            }
            SeaCreatureTracker.CLIENT.field_1724.method_5783(class_3417.field_15224, 100.0f, 0.1f);
        }
    }

    private static void checkCapNotification() {
        if (!SkyblockerConfigManager.get().helpers.fishing.seaCreatureCapNotification) {
            return;
        }
        if (SeaCreatureTracker.seaCreatureCount() == SeaCreatureTracker.getSeaCreatureCap()) {
            TitleContainer.addTitle(new Title(class_2561.method_43471((String)"skyblocker.config.helpers.fishing.seaCreatureCapNotification.notification").method_27692(class_124.field_1061)), 60);
            if (SeaCreatureTracker.CLIENT.field_1724 == null) {
                return;
            }
            SeaCreatureTracker.CLIENT.field_1724.method_5783(class_3417.field_15224, 100.0f, 0.1f);
        }
    }

    private static void onChatMessage(String s) {
        if (!SkyblockerConfigManager.get().helpers.fishing.enableFishingHud) {
            return;
        }
        String message = class_124.method_539((String)s);
        if (DOUBLE_HOOK_PATTERN.matcher(message).find()) {
            doubleHook = true;
            return;
        }
        for (SeaCreature creature : SeaCreature.values()) {
            if (!creature.chatMessage.equals(message)) continue;
            lastCatch = creature;
            break;
        }
    }

    protected static long getOldestSeaCreatureAge() {
        return System.currentTimeMillis() - SeaCreatureTracker.seaCreatures.sequencedValues().getFirst().spawnTime;
    }

    protected static Boolean isCreaturesAlive() {
        return !seaCreatures.isEmpty();
    }

    protected static ObjectFloatPair<class_2561> getTimerText(long currentTime) {
        long maxTime = (long)SkyblockerConfigManager.get().helpers.fishing.timerLength * 1000L;
        class_5250 time = SkyblockTime.formatTime((float)(maxTime - currentTime) / 1000.0f);
        float percentage = (float)(maxTime - currentTime) / (float)maxTime * 100.0f;
        return ObjectFloatPair.of((Object)time, (float)percentage);
    }

    protected static int seaCreatureCount() {
        return seaCreatures.size();
    }

    protected static int getSeaCreatureCap() {
        return switch (Utils.getLocation()) {
            case Location.CRYSTAL_HOLLOWS -> 20;
            case Location.CRIMSON_ISLE -> 5;
            default -> SkyblockerConfigManager.get().helpers.fishing.seaCreatureCap;
        };
    }

    static {
        doubleHook = false;
    }

    record LiveSeaCreature(SeaCreature seaCreature, class_1297 entity, Long spawnTime) {
    }
}

