/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.foraging;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.ForagingConfig;
import de.hysky.skyblocker.skyblock.item.ItemCooldowns;
import de.hysky.skyblocker.skyblock.tabhud.util.PlayerListManager;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.RenderHelper;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_9322;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SweepOverlay {
    private static final Logger LOGGER = LoggerFactory.getLogger(SweepOverlay.class);
    private static final class_310 CLIENT = class_310.method_1551();
    private static float[] colorComponents;
    private static final int MAX_WOOD_CAP = 35;
    private static final Pattern SWEEP_VALUE_PATTERN;
    private static boolean sweepStatNoticeShown;
    private static final Set<String> VALID_AXES;
    private static final Set<String> THROWABLE_AXES;
    private static final class_2338[] NEIGHBOR_OFFSETS;
    private static final Map<class_2248, Float> TOUGHNESS_MAP;

    @Init
    public static void init() {
        SweepOverlay.configCallback(SkyblockerConfigManager.get().foraging.sweepOverlay.sweepOverlayColor);
        WorldRenderEvents.AFTER_TRANSLUCENT.register(SweepOverlay::render);
    }

    private static boolean isValidLocation() {
        return Utils.isInGalatea() || Utils.isInPark() || Utils.isInHub() || Utils.isInPrivateIsland();
    }

    private static void render(WorldRenderContext wrc) {
        class_2680 state;
        class_243 look;
        class_243 end;
        class_243 start;
        class_3959 context;
        class_3965 hitResult;
        class_239 class_2392;
        ForagingConfig.SweepOverlay config = SkyblockerConfigManager.get().foraging.sweepOverlay;
        if (!SweepOverlay.isValidLocation() || !config.enableSweepOverlay || SweepOverlay.CLIENT.field_1724 == null || SweepOverlay.CLIENT.field_1687 == null) {
            return;
        }
        class_1799 heldItem = SweepOverlay.CLIENT.field_1724.method_6047();
        String itemId = ItemUtils.getItemId((class_9322)heldItem);
        boolean isValidAxe = VALID_AXES.contains(itemId);
        boolean isThrowableAxe = THROWABLE_AXES.contains(itemId);
        if (!isValidAxe && !isThrowableAxe) {
            return;
        }
        class_3965 blockHitResult = null;
        boolean isThrown = false;
        if (isValidAxe && SweepOverlay.CLIENT.field_1765 != null && SweepOverlay.CLIENT.field_1765.method_17783() == class_239.class_240.field_1332 && (class_2392 = SweepOverlay.CLIENT.field_1765) instanceof class_3965) {
            class_3965 hitResult2;
            blockHitResult = hitResult2 = (class_3965)class_2392;
        } else if (isThrowableAxe && config.enableThrownAbilityOverlay && !ItemCooldowns.isOnCooldown(heldItem) && (hitResult = SweepOverlay.CLIENT.field_1687.method_17742(context = new class_3959(start = SweepOverlay.CLIENT.field_1724.method_5836(1.0f), end = start.method_1019((look = SweepOverlay.CLIENT.field_1724.method_5828(1.0f)).method_1021(50.0)), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)SweepOverlay.CLIENT.field_1724))).method_17783() == class_239.class_240.field_1332 && hitResult instanceof class_3965) {
            class_3965 rayHitResult;
            blockHitResult = rayHitResult = hitResult;
            isThrown = true;
        }
        if (blockHitResult != null && SweepOverlay.isLog(state = SweepOverlay.CLIENT.field_1687.method_8320(blockHitResult.method_17777()))) {
            SweepOverlay.renderConnectedLogs(wrc, blockHitResult, state, isThrown);
        }
    }

    private static boolean isLog(class_2680 state) {
        if (Utils.isInGalatea()) {
            return state.method_27852(class_2246.field_10436) || state.method_27852(class_2246.field_10558) || state.method_27852(class_2246.field_37545) || state.method_27852(class_2246.field_37549);
        }
        if (Utils.isInHub()) {
            return state.method_27852(class_2246.field_10431) || state.method_27852(class_2246.field_10126);
        }
        return state.method_26164(class_3481.field_15475);
    }

    private static float getSweepStat() {
        if (SweepOverlay.CLIENT.field_1724 == null) {
            return 0.0f;
        }
        List<String> playerList = PlayerListManager.getPlayerStringList();
        if (playerList != null) {
            for (String entry : playerList) {
                Matcher matcher = SWEEP_VALUE_PATTERN.matcher(entry);
                if (!matcher.find()) continue;
                try {
                    return Float.parseFloat(matcher.group(1));
                }
                catch (NumberFormatException e) {
                    LOGGER.warn("Failed to parse Sweep stat from tab list: {}. Error: {}", (Object)entry, (Object)e.getMessage());
                }
            }
        }
        if (!sweepStatNoticeShown && (Utils.isInPark() || Utils.isInGalatea()) && SweepOverlay.CLIENT.field_1724 != null) {
            SweepOverlay.CLIENT.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.foraging.sweepOverlay.sweepStatMissingMessage").method_27692(class_124.field_1061)), false);
            sweepStatNoticeShown = true;
        }
        return 0.0f;
    }

    private static int calculateMaxWood(float sweepStat, float toughness) {
        if (toughness <= 0.0f) {
            return Math.min(35, (int)Math.floor(sweepStat));
        }
        int logs = (int)Math.floor(sweepStat / toughness);
        return Math.min(35, logs);
    }

    private static float getToughness(class_2680 state) {
        return TOUGHNESS_MAP.getOrDefault(state.method_26204(), Float.valueOf(1.0f)).floatValue();
    }

    private static void renderConnectedLogs(WorldRenderContext wrc, class_3965 blockHitResult, class_2680 state, boolean isThrown) {
        class_2338 startPos = blockHitResult.method_17777();
        class_638 world = SweepOverlay.CLIENT.field_1687;
        float sweepStat = SweepOverlay.getSweepStat();
        if (sweepStat <= 0.0f) {
            return;
        }
        float[] renderColor = colorComponents;
        if (isThrown) {
            renderColor = new float[]{colorComponents[0] * 0.7f, colorComponents[1] * 0.7f, colorComponents[2] * 0.7f, colorComponents[3]};
        }
        HashSet<class_2338> visited = new HashSet<class_2338>();
        ArrayDeque<class_2338> queue = new ArrayDeque<class_2338>();
        int woodCount = 0;
        float toughness = SweepOverlay.getToughness(state);
        int maxWood = SweepOverlay.calculateMaxWood(sweepStat, toughness);
        if (isThrown) {
            maxWood = (int)((float)maxWood * 0.5f);
        }
        queue.add(startPos);
        visited.add(startPos);
        while (woodCount < maxWood && !queue.isEmpty()) {
            class_2338 pos = (class_2338)queue.poll();
            class_2680 currentState = world.method_8320(pos);
            if (!SweepOverlay.isLog(currentState)) continue;
            ++woodCount;
            RenderHelper.renderFilled(wrc, pos, renderColor, renderColor[3], false);
            for (class_2338 offset : NEIGHBOR_OFFSETS) {
                class_2338 neighbor = pos.method_10081((class_2382)offset);
                if (visited.contains(neighbor) || queue.contains(neighbor) || !SweepOverlay.isLog(world.method_8320(neighbor))) continue;
                queue.add(neighbor);
                visited.add(neighbor);
            }
        }
    }

    public static void configCallback(Color color) {
        colorComponents = color.getRGBComponents(null);
    }

    static {
        SWEEP_VALUE_PATTERN = Pattern.compile("Sweep:\\s*(?:\u222e|\u00a7[0-9a-fk-or])*(\\d+)");
        sweepStatNoticeShown = false;
        VALID_AXES = Set.of("JUNGLE_AXE", "TREECAPITATOR_AXE", "FIG_AXE", "FIGSTONE_AXE", "ROOKIE_AXE", "PROMISING_AXE", "SWEET_AXE", "EFFICIENT_AXE");
        THROWABLE_AXES = Set.of("FIG_AXE", "FIGSTONE_AXE", "JUNGLE_AXE", "TREECAPITATOR_AXE");
        NEIGHBOR_OFFSETS = new class_2338[]{new class_2338(-1, -1, -1), new class_2338(-1, -1, 0), new class_2338(-1, -1, 1), new class_2338(-1, 0, -1), new class_2338(-1, 0, 0), new class_2338(-1, 0, 1), new class_2338(-1, 1, -1), new class_2338(-1, 1, 0), new class_2338(-1, 1, 1), new class_2338(0, -1, -1), new class_2338(0, -1, 0), new class_2338(0, -1, 1), new class_2338(0, 0, -1), new class_2338(0, 0, 1), new class_2338(0, 1, -1), new class_2338(0, 1, 0), new class_2338(0, 1, 1), new class_2338(1, -1, -1), new class_2338(1, -1, 0), new class_2338(1, -1, 1), new class_2338(1, 0, -1), new class_2338(1, 0, 0), new class_2338(1, 0, 1), new class_2338(1, 1, -1), new class_2338(1, 1, 0), new class_2338(1, 1, 1)};
        TOUGHNESS_MAP = Map.of(class_2246.field_10436, Float.valueOf(7.0f), class_2246.field_10558, Float.valueOf(7.0f), class_2246.field_37545, Float.valueOf(50.0f), class_2246.field_37549, Float.valueOf(50.0f));
    }
}

