/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.galatea;

import de.hysky.skyblocker.events.WorldEvents;
import de.hysky.skyblocker.utils.ColorUtils;
import de.hysky.skyblocker.utils.render.RenderHelper;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_638;

public abstract class AbstractBlockHighlighter {
    protected final Set<class_2338> highlightedBlocks = new ObjectOpenHashSet();
    protected final float[] colour;
    protected final Predicate<class_2680> statePredicate;

    protected AbstractBlockHighlighter(class_2248 target, class_1767 colour) {
        this((class_2680 state) -> state.method_27852(target), colour);
    }

    protected AbstractBlockHighlighter(Predicate<class_2680> statePredicate, class_1767 colour) {
        this.statePredicate = statePredicate;
        this.colour = ColorUtils.getFloatComponents(colour);
    }

    protected void init() {
        ClientChunkEvents.CHUNK_LOAD.register(this::onChunkLoad);
        ClientChunkEvents.CHUNK_UNLOAD.register(this::onChunkUnload);
        WorldRenderEvents.AFTER_TRANSLUCENT.register(this::render);
        ClientPlayConnectionEvents.JOIN.register((_handler, _sender, _client) -> this.reset());
        WorldEvents.BLOCK_STATE_UPDATE.register(this::onBlockUpdate);
    }

    protected void onBlockUpdate(class_2338 pos, class_2680 oldState, class_2680 newState) {
        if (!this.shouldProcess()) {
            return;
        }
        if (this.statePredicate.test(newState)) {
            this.highlightedBlocks.add(pos.method_10062());
        } else {
            this.highlightedBlocks.remove(pos);
        }
    }

    protected void onChunkLoad(class_638 world, class_2818 chunk) {
        if (!this.shouldProcess()) {
            return;
        }
        chunk.method_51525(this.statePredicate, (pos, state) -> this.highlightedBlocks.add(pos.method_10062()));
    }

    protected void onChunkUnload(class_638 world, class_2818 chunk) {
        if (!this.shouldProcess()) {
            return;
        }
        Iterator<class_2338> iterator = this.highlightedBlocks.iterator();
        while (iterator.hasNext()) {
            class_2338 pos = iterator.next();
            class_2791 holder = world.method_22350(pos);
            if (!holder.equals(chunk)) continue;
            iterator.remove();
        }
    }

    private void render(WorldRenderContext context) {
        class_310 client = class_310.method_1551();
        if (!this.shouldProcess() || client.field_1687 == null) {
            return;
        }
        for (class_2338 highlight : this.highlightedBlocks) {
            class_238 outline = RenderHelper.getBlockBoundingBox(client.field_1687, highlight);
            if (outline == null) continue;
            RenderHelper.renderFilled(context, outline, this.colour, 0.4f, false);
        }
    }

    public void reset() {
        this.highlightedBlocks.clear();
    }

    protected abstract boolean shouldProcess();
}

