/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.galatea;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.galatea.AbstractBlockHighlighter;
import de.hysky.skyblocker.utils.Utils;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.class_1767;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2472;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class SeaLumiesHighlighter
extends AbstractBlockHighlighter {
    private final Set<class_2338> allBlocks = new ObjectOpenHashSet();
    public static final SeaLumiesHighlighter INSTANCE = new SeaLumiesHighlighter();

    @Override
    public void onBlockUpdate(class_2338 pos, class_2680 oldState, class_2680 newState) {
        if (!this.shouldProcess()) {
            return;
        }
        if (this.statePredicate.test(newState)) {
            this.allBlocks.add(pos.method_10062());
            if (this.isEnabled() && this.isEnoughPickles(newState)) {
                this.highlightedBlocks.add(pos.method_10062());
            }
        } else {
            this.allBlocks.remove(pos);
            this.highlightedBlocks.remove(pos);
        }
    }

    private SeaLumiesHighlighter() {
        super(class_2246.field_10476, class_1767.field_7955);
    }

    @Init
    public static void initClass() {
        INSTANCE.init();
    }

    @Override
    protected void onChunkUnload(class_638 world, class_2818 chunk) {
        if (!this.shouldProcess()) {
            return;
        }
        Iterator<class_2338> iterator = this.allBlocks.iterator();
        while (iterator.hasNext()) {
            class_2338 pos = iterator.next();
            class_2791 holder = world.method_22350(pos);
            if (!holder.equals(chunk)) continue;
            iterator.remove();
            this.highlightedBlocks.remove(pos);
        }
    }

    @Override
    protected void onChunkLoad(class_638 world, class_2818 chunk) {
        if (!this.shouldProcess()) {
            return;
        }
        chunk.method_51525(this.statePredicate, (pos, state) -> {
            this.allBlocks.add(pos.method_10062());
            if (this.isEnabled() && this.isEnoughPickles((class_2680)state)) {
                this.highlightedBlocks.add(pos.method_10062());
            }
        });
    }

    @Override
    protected boolean shouldProcess() {
        return Utils.isInGalatea();
    }

    @Override
    public void reset() {
        this.allBlocks.clear();
        this.highlightedBlocks.clear();
    }

    public void configCallback() {
        this.highlightedBlocks.clear();
        class_638 world = class_310.method_1551().field_1687;
        if (!this.shouldProcess() || world == null || !this.isEnabled()) {
            return;
        }
        for (class_2338 pos : this.allBlocks) {
            class_2680 state = world.method_8320(pos);
            if (!this.statePredicate.test(state) || !this.isEnoughPickles(state)) continue;
            this.highlightedBlocks.add(pos);
        }
    }

    private boolean isEnoughPickles(class_2680 state) {
        return state.method_28498((class_2769)class_2472.field_11472) && (Integer)state.method_11654((class_2769)class_2472.field_11472) >= SkyblockerConfigManager.get().foraging.galatea.seaLumiesMinimumCount;
    }

    private boolean isEnabled() {
        return SkyblockerConfigManager.get().foraging.galatea.enableSeaLumiesHighlighter;
    }
}

