/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.garden;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.tabhud.config.WidgetsConfigurationScreen;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import it.unimi.dsi.fastutil.floats.FloatLongPair;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongLongPair;
import it.unimi.dsi.fastutil.longs.LongPriorityQueue;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Locale;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.fabricmc.fabric.api.event.client.player.ClientPlayerBlockBreakEvents;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2514;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_9322;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FarmingHud {
    private static final Logger LOGGER = LoggerFactory.getLogger(FarmingHud.class);
    private static final class_2960 FARMING_HUD = class_2960.method_60655((String)"skyblocker", (String)"farming_hud");
    public static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance(Locale.US);
    private static final Pattern FARMING_XP = Pattern.compile("\\+(?<xp>\\d+(?:\\.\\d+)?) Farming \\((?<percent>[\\d,]+(?:\\.\\d+)?%|[\\d,]+/[\\d,]+)\\)");
    private static final class_310 client = class_310.method_1551();
    private static CounterType counterType = CounterType.NONE;
    private static final Deque<LongLongPair> counter = new ArrayDeque<LongLongPair>();
    private static final LongPriorityQueue blockBreaks = new LongArrayFIFOQueue();
    private static final Queue<FloatLongPair> farmingXp = new ArrayDeque<FloatLongPair>();
    private static float farmingXpPercentProgress;

    @Init
    public static void init() {
        HudElementRegistry.attachElementAfter((class_2960)VanillaHudElements.STATUS_EFFECTS, (class_2960)FARMING_HUD, (context, tickCounter) -> {
            if (FarmingHud.shouldRender()) {
                if (!counter.isEmpty() && counter.peek().rightLong() + 5000L < System.currentTimeMillis()) {
                    counter.poll();
                }
                if (!blockBreaks.isEmpty() && blockBreaks.firstLong() + 1000L < System.currentTimeMillis()) {
                    blockBreaks.dequeueLong();
                }
                if (!farmingXp.isEmpty() && farmingXp.peek().rightLong() + 1000L < System.currentTimeMillis()) {
                    farmingXp.poll();
                }
                assert (FarmingHud.client.field_1724 != null);
                class_1799 stack = FarmingHud.client.field_1724.method_6047();
                if (stack == null || FarmingHud.tryGetCounter(stack, CounterType.CULTIVATING) && FarmingHud.tryGetCounter(stack, CounterType.COUNTER)) {
                    counterType = CounterType.NONE;
                }
            }
        });
        ClientPlayerBlockBreakEvents.AFTER.register((world, player, pos, state) -> {
            if (FarmingHud.shouldRender()) {
                blockBreaks.enqueue(System.currentTimeMillis());
            }
        });
        ClientReceiveMessageEvents.ALLOW_GAME.register((message, overlay) -> {
            Matcher matcher;
            if (FarmingHud.shouldRender() && overlay && (matcher = FARMING_XP.matcher(class_124.method_539((String)message.getString()))).find()) {
                try {
                    farmingXp.offer(FloatLongPair.of((float)NUMBER_FORMAT.parse(matcher.group("xp")).floatValue(), (long)System.currentTimeMillis()));
                    farmingXpPercentProgress = NUMBER_FORMAT.parse(matcher.group("percent")).floatValue();
                }
                catch (ParseException e) {
                    LOGGER.error("[Skyblocker Farming HUD] Failed to parse farming xp", (Throwable)e);
                }
            }
            return true;
        });
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"hud").then(ClientCommandManager.literal((String)"farming").executes(Scheduler.queueOpenScreenCommand(() -> new WidgetsConfigurationScreen(Location.GARDEN, "hud_garden", null)))))));
    }

    private static boolean tryGetCounter(class_1799 stack, CounterType counterType) {
        class_2487 customData = ItemUtils.getCustomData((class_9322)stack);
        if (customData.method_33133() || !(customData.method_10580(counterType.nbtKey) instanceof class_2514)) {
            return true;
        }
        long count = customData.method_68080(counterType.nbtKey, 0L);
        if (FarmingHud.counterType != counterType) {
            counter.clear();
            FarmingHud.counterType = counterType;
        }
        if (counter.isEmpty() || counter.peekLast().leftLong() != count) {
            counter.offer(LongLongPair.of((long)count, (long)System.currentTimeMillis()));
        }
        return false;
    }

    private static boolean shouldRender() {
        return SkyblockerConfigManager.get().farming.garden.farmingHud.enableHud && FarmingHud.client.field_1724 != null && Utils.getLocation() == Location.GARDEN;
    }

    public static String counterText() {
        return FarmingHud.counterType.text;
    }

    public static long counter() {
        return counter.isEmpty() ? 0L : counter.peekLast().leftLong();
    }

    public static float cropsPerMinute() {
        if (counter.isEmpty()) {
            return 0.0f;
        }
        LongLongPair first = counter.peek();
        LongLongPair last = counter.peekLast();
        return (float)(last.leftLong() - first.leftLong()) / (float)(last.rightLong() - first.rightLong()) * 60000.0f;
    }

    public static double blockBreaks() {
        if (blockBreaks.isEmpty()) {
            return 0.0;
        }
        long firstTimestamp = blockBreaks.firstLong();
        long lastTimestamp = blockBreaks.lastLong();
        return (double)Math.round((double)(blockBreaks.size() - 1) / (double)(lastTimestamp - firstTimestamp) * 10000.0) / 10.0;
    }

    public static float farmingXpPercentProgress() {
        return Math.clamp(farmingXpPercentProgress, 0.0f, 100.0f);
    }

    public static double farmingXpPerHour() {
        if (farmingXp.isEmpty()) {
            return 0.0;
        }
        return (double)Math.round((double)farmingXp.peek().leftFloat() * FarmingHud.blockBreaks() * 3600.0 * 10.0) / 10.0;
    }

    public static enum CounterType {
        NONE("", "No Counter"),
        COUNTER("mined_crops", "Counter: "),
        CULTIVATING("farmed_cultivating", "Cultivating Counter: ");

        private final String nbtKey;
        private final String text;

        private CounterType(String nbtKey, String text) {
            this.nbtKey = nbtKey;
            this.text = text;
        }

        public boolean matchesText(String textToMatch) {
            return this.text.equals(textToMatch);
        }
    }
}

