/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.garden;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.garden.CurrentJacobCrop;
import de.hysky.skyblocker.skyblock.garden.GardenConstants;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.container.SimpleContainerSolver;
import de.hysky.skyblocker.utils.render.gui.ColorHighlight;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1799;

public class StereoHarmonyHelper
extends SimpleContainerSolver {
    private static final Pattern PEST_NAME_PATTERN = Pattern.compile("^When playing, (?<name>.+) Pests are(?: more)*");
    public static final StereoHarmonyHelper INSTANCE = new StereoHarmonyHelper();

    private StereoHarmonyHelper() {
        super("Stereo Harmony");
    }

    @Override
    public boolean isEnabled() {
        return SkyblockerConfigManager.get().farming.garden.enableStereoHarmonyHelperForContest;
    }

    @Override
    public List<ColorHighlight> getColors(Int2ObjectMap<class_1799> slots) {
        ArrayList<ColorHighlight> highlights = new ArrayList<ColorHighlight>();
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            boolean isPlaying;
            Matcher matcher = ItemUtils.getLoreLineIfMatch((class_1799)entry.getValue(), PEST_NAME_PATTERN);
            if (matcher == null) continue;
            String pestName = matcher.group("name").trim();
            String crop = GardenConstants.CROP_BY_PEST.get(pestName);
            boolean bl = isPlaying = ItemUtils.getLoreLineIf((class_1799)entry.getValue(), text -> text.equals("PLAYING")) != null;
            if (!Objects.equals(crop, CurrentJacobCrop.CURRENT_CROP_CONTEST)) continue;
            highlights.add(isPlaying ? ColorHighlight.yellow(entry.getIntKey()) : ColorHighlight.green(entry.getIntKey()));
        }
        return highlights;
    }
}

