/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.utils.ItemUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_9322;

public class ItemCooldowns {
    private static final String JUNGLE_AXE_ID = "JUNGLE_AXE";
    private static final String TREECAPITATOR_ID = "TREECAPITATOR_AXE";
    private static final String FIG_AXE_ID = "FIG_AXE";
    private static final String FIGSTONE_ID = "FIGSTONE_AXE";
    private static final String GRAPPLING_HOOK_ID = "GRAPPLING_HOOK";
    private static final String ROGUE_SWORD_ID = "ROGUE_SWORD";
    private static final String LEAPING_SWORD_ID = "LEAPING_SWORD";
    private static final String SILK_EDGE_SWORD_ID = "SILK_EDGE_SWORD";
    private static final String GREAT_SPOOK_STAFF_ID = "GREAT_SPOOK_STAFF";
    private static final String SPIRIT_LEAP_ID = "SPIRIT_LEAP";
    private static final String GIANTS_SWORD_ID = "GIANTS_SWORD";
    private static final String SHADOW_FURY_ID = "SHADOW_FURY";
    private static final String LIVID_DAGGER_ID = "LIVID_DAGGER";
    private static final String INK_WAND_ID = "INK_WAND";
    private static final List<String> BAT_ARMOR_IDS = List.of("BAT_PERSON_HELMET", "BAT_PERSON_CHESTPLATE", "BAT_PERSON_LEGGINGS", "BAT_PERSON_BOOTS");
    private static final Map<String, CooldownEntry> ITEM_COOLDOWNS = new HashMap<String, CooldownEntry>();

    @Init
    public static void init() {
        UseItemCallback.EVENT.register(ItemCooldowns::onItemInteract);
    }

    private static class_1269 onItemInteract(class_1657 player, class_1937 world, class_1268 hand) {
        String usedItemId;
        if (!SkyblockerConfigManager.get().uiAndVisuals.itemCooldown.enableItemCooldowns) {
            return class_1269.field_5811;
        }
        switch (usedItemId = ItemUtils.getItemId((class_9322)player.method_6047())) {
            case "FIG_AXE": 
            case "FIGSTONE_AXE": 
            case "JUNGLE_AXE": 
            case "TREECAPITATOR_AXE": {
                ItemCooldowns.handleItemCooldown(usedItemId, 1000);
                break;
            }
            case "SILK_EDGE_SWORD": 
            case "LEAPING_SWORD": {
                ItemCooldowns.handleItemCooldown(usedItemId, 1000);
                break;
            }
            case "GRAPPLING_HOOK": {
                ItemCooldowns.handleItemCooldown(GRAPPLING_HOOK_ID, 2000, player.field_7513 != null && !ItemCooldowns.isWearingBatArmor(player));
                break;
            }
            case "ROGUE_SWORD": 
            case "SPIRIT_LEAP": 
            case "LIVID_DAGGER": {
                ItemCooldowns.handleItemCooldown(usedItemId, 5000);
                break;
            }
            case "SHADOW_FURY": {
                ItemCooldowns.handleItemCooldown(SHADOW_FURY_ID, 15000);
                break;
            }
            case "INK_WAND": 
            case "GIANTS_SWORD": {
                ItemCooldowns.handleItemCooldown(usedItemId, 30000);
                break;
            }
            case "GREAT_SPOOK_STAFF": {
                ItemCooldowns.handleItemCooldown(GREAT_SPOOK_STAFF_ID, 60000);
                break;
            }
        }
        return class_1269.field_5811;
    }

    private static void handleItemCooldown(String itemId, int cooldownTime, boolean additionalCondition) {
        if (!ItemCooldowns.isOnCooldown(itemId) && additionalCondition) {
            ITEM_COOLDOWNS.put(itemId, new CooldownEntry(cooldownTime));
        }
    }

    private static void handleItemCooldown(String itemId, int cooldownTime) {
        ItemCooldowns.handleItemCooldown(itemId, cooldownTime, true);
    }

    public static boolean isOnCooldown(class_1799 itemStack) {
        return ItemCooldowns.isOnCooldown(ItemUtils.getItemId((class_9322)itemStack));
    }

    private static boolean isOnCooldown(String itemId) {
        if (ITEM_COOLDOWNS.containsKey(itemId)) {
            CooldownEntry cooldownEntry = ITEM_COOLDOWNS.get(itemId);
            if (cooldownEntry.isOnCooldown()) {
                return true;
            }
            ITEM_COOLDOWNS.remove(itemId);
            return false;
        }
        return false;
    }

    public static CooldownEntry getItemCooldownEntry(class_1799 itemStack) {
        return ITEM_COOLDOWNS.get(ItemUtils.getItemId((class_9322)itemStack));
    }

    private static boolean isWearingBatArmor(class_1657 player) {
        for (class_1799 stack : ItemUtils.getArmor((class_1309)player)) {
            String itemId = ItemUtils.getItemId((class_9322)stack);
            if (BAT_ARMOR_IDS.contains(itemId)) continue;
            return false;
        }
        return true;
    }

    public record CooldownEntry(int cooldown, long startTime) {
        public CooldownEntry(int cooldown) {
            this(cooldown, System.currentTimeMillis());
        }

        public boolean isOnCooldown() {
            return this.startTime + (long)this.cooldown > System.currentTimeMillis();
        }

        public long getRemainingCooldown() {
            long time = this.startTime + (long)this.cooldown - System.currentTimeMillis();
            return Math.max(time, 0L);
        }

        public float getRemainingCooldownPercent() {
            return this.isOnCooldown() ? (float)this.getRemainingCooldown() / (float)this.cooldown : 0.0f;
        }
    }
}

