/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.background.adders;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.item.PetInfo;
import de.hysky.skyblocker.skyblock.item.SkyblockItemRarity;
import de.hysky.skyblocker.skyblock.item.background.ColoredItemBackground;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.Utils;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectReferencePair;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_9848;

public class ItemRarityBackground
extends ColoredItemBackground<SkyblockItemRarity> {
    public static final List<ObjectReferencePair<String, SkyblockItemRarity>> LORE_RARITIES = List.of(ObjectReferencePair.of((Object)"ADMIN", (Object)((Object)SkyblockItemRarity.ADMIN)), ObjectReferencePair.of((Object)"ULTIMATE", (Object)((Object)SkyblockItemRarity.ULTIMATE)), ObjectReferencePair.of((Object)"SPECIAL", (Object)((Object)SkyblockItemRarity.SPECIAL)), ObjectReferencePair.of((Object)"DIVINE", (Object)((Object)SkyblockItemRarity.DIVINE)), ObjectReferencePair.of((Object)"MYTHIC", (Object)((Object)SkyblockItemRarity.MYTHIC)), ObjectReferencePair.of((Object)"LEGENDARY", (Object)((Object)SkyblockItemRarity.LEGENDARY)), ObjectReferencePair.of((Object)"LEGENJERRY", (Object)((Object)SkyblockItemRarity.LEGENDARY)), ObjectReferencePair.of((Object)"EPIC", (Object)((Object)SkyblockItemRarity.EPIC)), ObjectReferencePair.of((Object)"RARE", (Object)((Object)SkyblockItemRarity.RARE)), ObjectReferencePair.of((Object)"UNCOMMON", (Object)((Object)SkyblockItemRarity.UNCOMMON)), ObjectReferencePair.of((Object)"COMMON", (Object)((Object)SkyblockItemRarity.COMMON)));
    private static final List<Predicate<String>> INVENTORY_TITLES = List.of(title -> title.contains("The Hex"), title -> title.equals("Craft Item"), title -> title.equals("Anvil"), title -> title.equals("Reforge Anvil"));

    @Override
    public boolean isEnabled() {
        return SkyblockerConfigManager.get().general.itemInfoDisplay.itemRarityBackgrounds;
    }

    @Override
    protected SkyblockItemRarity getColorKey(class_1799 stack, Int2ReferenceOpenHashMap<SkyblockItemRarity> cache) {
        int hashCode;
        if (stack == null || stack.method_7960()) {
            return null;
        }
        int n = hashCode = stack.getUuid().isEmpty() ? System.identityHashCode(stack) : stack.getUuid().hashCode();
        if (cache.containsKey(hashCode)) {
            return (SkyblockItemRarity)((Object)cache.get(hashCode));
        }
        if (!stack.getSkyblockId().equals("PET")) {
            List<class_2561> lore = ItemUtils.getLore(stack);
            List<String> tooltip = lore.stream().map(class_2561::getString).toList();
            for (ObjectReferencePair<String, SkyblockItemRarity> key : LORE_RARITIES) {
                if (!tooltip.stream().anyMatch(line -> line.contains((CharSequence)key.left()))) continue;
                SkyblockItemRarity rarity = (SkyblockItemRarity)((Object)key.right());
                cache.put(hashCode, (Object)rarity);
                return rarity;
            }
        } else {
            PetInfo info = stack.getPetInfo();
            if (!info.isEmpty()) {
                SkyblockItemRarity rarity = info.item().isPresent() && info.item().get().equals("PET_ITEM_TIER_BOOST") ? info.rarity().next() : info.rarity();
                cache.put(hashCode, (Object)rarity);
                return rarity;
            }
        }
        cache.put(hashCode, null);
        return null;
    }

    @Override
    protected void draw(class_332 context, int x, int y, SkyblockItemRarity rarity) {
        context.method_52710(class_10799.field_56883, this.getSprite(), x, y, 16, 16, class_9848.method_61318((float)SkyblockerConfigManager.get().general.itemInfoDisplay.itemBackgroundOpacity, (float)rarity.r, (float)rarity.g, (float)rarity.b));
    }

    @Override
    protected void onScreenChange(String title, class_437 screen) {
        if (Utils.isOnSkyblock() && INVENTORY_TITLES.stream().anyMatch(predicate -> predicate.test(title))) {
            ScreenEvents.remove((class_437)screen).register(s -> this.clearCache());
        }
    }
}

