/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.tooltip.adders;

import de.hysky.skyblocker.skyblock.item.tooltip.SimpleTooltipAdder;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.ObtainedDateTooltip;
import de.hysky.skyblocker.skyblock.item.tooltip.info.TooltipInfoType;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.ItemUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3542;
import net.minecraft.class_5250;
import net.minecraft.class_9282;
import net.minecraft.class_9322;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class ColorTooltip
extends SimpleTooltipAdder {
    private static final long WITHER_GLITCHED_AFTER_DATE = 1605830400000L;

    public ColorTooltip(int priority) {
        super(priority);
    }

    @Override
    public boolean isEnabled() {
        return TooltipInfoType.COLOR.isTooltipEnabled();
    }

    @Override
    public void addToTooltip(@Nullable class_1735 focusedSlot, class_1799 stack, List<class_2561> lines) {
        String internalID = stack.getSkyblockId();
        if (TooltipInfoType.COLOR.hasOrNullWarning(internalID) && stack.method_57826(class_9334.field_49644)) {
            int dyeColor = ((class_9282)stack.method_58694(class_9334.field_49644)).comp_2384() & 0xFFFFFF;
            String colorHex = String.format("%06X", dyeColor);
            String expectedHex = ColorTooltip.getExpectedHex(internalID);
            boolean correctLine = false;
            for (class_2561 text : lines) {
                String existingTooltip = text.getString() + " ";
                if (!existingTooltip.startsWith("Color: ")) continue;
                correctLine = true;
                ColorTooltip.addExoticTooltip(lines, stack, internalID, colorHex, expectedHex, existingTooltip);
                break;
            }
            if (!correctLine) {
                ColorTooltip.addExoticTooltip(lines, stack, internalID, colorHex, expectedHex, "");
            }
        }
    }

    private static void addExoticTooltip(List<class_2561> lines, class_1799 stack, String internalID, String colorHex, String expectedHex, String existingTooltip) {
        if (!(expectedHex == null || colorHex.equalsIgnoreCase(expectedHex) || ColorTooltip.isException(internalID, colorHex) || ColorTooltip.intendedDyed(ItemUtils.getCustomData((class_9322)stack)))) {
            DyeType type = ColorTooltip.checkDyeType(stack, colorHex);
            lines.add(1, (class_2561)class_2561.method_43470((String)(existingTooltip + String.valueOf(class_124.field_1063) + "(")).method_10852((class_2561)type.getTranslatedText()).method_10852((class_2561)class_2561.method_43470((String)" - ")).method_10852((class_2561)class_2561.method_43470((String)("#" + colorHex)).method_54663(Integer.decode("0x" + colorHex).intValue())).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1063)));
        }
    }

    private static String getExpectedHex(String id) {
        String color = TooltipInfoType.COLOR.getData().get(id);
        if (color != null) {
            String[] RGBValues = color.split(",");
            return String.format("%02X%02X%02X", Integer.parseInt(RGBValues[0]), Integer.parseInt(RGBValues[1]), Integer.parseInt(RGBValues[2]));
        }
        return null;
    }

    private static boolean isException(String id, String hex) {
        boolean bl;
        String string = id;
        Objects.requireNonNull(string);
        String string2 = string;
        int n = 0;
        block10: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class}, (Object)string2, n)) {
                case 0: {
                    String it = string2;
                    if (!(it.startsWith("LEATHER") || it.equals("GHOST_BOOTS") || Constants.SEYMOUR_IDS.contains(it))) {
                        n = 1;
                        continue block10;
                    }
                    bl = true;
                    break block10;
                }
                case 1: {
                    String it = string2;
                    if (!it.startsWith("RANCHER")) {
                        n = 2;
                        continue block10;
                    }
                    bl = Constants.RANCHERS.contains(hex);
                    break block10;
                }
                case 2: {
                    String it = string2;
                    if (!it.contains("ADAPTIVE_CHESTPLATE")) {
                        n = 3;
                        continue block10;
                    }
                    bl = Constants.ADAPTIVE_CHEST.contains(hex);
                    break block10;
                }
                case 3: {
                    String it = string2;
                    if (!it.contains("ADAPTIVE")) {
                        n = 4;
                        continue block10;
                    }
                    bl = Constants.ADAPTIVE.contains(hex);
                    break block10;
                }
                case 4: {
                    String it = string2;
                    if (!it.contains("REAPER")) {
                        n = 5;
                        continue block10;
                    }
                    bl = Constants.REAPER.contains(hex);
                    break block10;
                }
                case 5: {
                    String it = string2;
                    if (!it.contains("FAIRY")) {
                        n = 6;
                        continue block10;
                    }
                    bl = Constants.FAIRY_HEXES.contains(hex);
                    break block10;
                }
                case 6: {
                    String it = string2;
                    if (!it.contains("CRYSTAL")) {
                        n = 7;
                        continue block10;
                    }
                    bl = Constants.CRYSTAL_HEXES.contains(hex);
                    break block10;
                }
                case 7: {
                    String it = string2;
                    if (!it.contains("SPOOK")) {
                        n = 8;
                        continue block10;
                    }
                    bl = Constants.SPOOK.contains(hex);
                    break block10;
                }
                default: {
                    bl = false;
                    break block10;
                }
            }
            break;
        }
        return bl;
    }

    private static DyeType checkDyeType(class_1799 stack, String hex) {
        DyeType dyeType;
        String string = hex;
        Objects.requireNonNull(string);
        String string2 = string;
        int n = 0;
        block7: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, String.class, String.class, String.class, String.class}, (Object)string2, n)) {
                case 0: {
                    String it = string2;
                    if (!Constants.CRYSTAL_HEXES.contains(it)) {
                        n = 1;
                        continue block7;
                    }
                    dyeType = DyeType.CRYSTAL;
                    break block7;
                }
                case 1: {
                    String it = string2;
                    if (!Constants.FAIRY_HEXES.contains(it)) {
                        n = 2;
                        continue block7;
                    }
                    dyeType = DyeType.FAIRY;
                    break block7;
                }
                case 2: {
                    String it = string2;
                    if (!Constants.OG_FAIRY_HEXES.contains(it)) {
                        n = 3;
                        continue block7;
                    }
                    dyeType = DyeType.OG_FAIRY;
                    break block7;
                }
                case 3: {
                    String it = string2;
                    if (!Constants.SPOOK.contains(it) || !stack.getSkyblockId().startsWith("FAIRY_")) {
                        n = 4;
                        continue block7;
                    }
                    dyeType = DyeType.SPOOK;
                    break block7;
                }
                case 4: {
                    String it = string2;
                    if (!Constants.GLITCHED.contains(it) || !ColorTooltip.isGlitched(stack, hex)) {
                        n = 5;
                        continue block7;
                    }
                    dyeType = DyeType.GLITCHED;
                    break block7;
                }
                default: {
                    dyeType = DyeType.EXOTIC;
                    break block7;
                }
            }
            break;
        }
        return dyeType;
    }

    private static boolean intendedDyed(class_2487 customData) {
        return customData.method_10545("dye_item");
    }

    private static boolean isGlitched(class_1799 stack, String hex) {
        String id = stack.getSkyblockId();
        if (id.contains("WITHER")) {
            return ColorTooltip.isWitherGlitched(id, hex, ObtainedDateTooltip.getLongTimestamp(stack));
        }
        String miscGlitchedId = Constants.MISC_GLITCHED_HEXES.get(hex);
        return miscGlitchedId != null && id.startsWith(miscGlitchedId);
    }

    private static boolean isWitherGlitched(String id, String hex, long obtained) {
        boolean bl;
        if (hex.equals("000000") && obtained < 1605830400000L) {
            return false;
        }
        String string = id;
        Objects.requireNonNull(string);
        String string2 = string;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, String.class, String.class}, (Object)string2, n)) {
                case 0: {
                    String it = string2;
                    if (!it.contains("CHESTPLATE")) {
                        n = 1;
                        continue block5;
                    }
                    if (Constants.WITHER_CHESTPLATE_HEXES.containsKey(hex) && Constants.WITHER_CHESTPLATE_HEXES.containsValue(it) && !Constants.WITHER_CHESTPLATE_HEXES.get(hex).equals(it)) {
                        bl = true;
                        break block5;
                    }
                    bl = false;
                    break block5;
                }
                case 1: {
                    String it = string2;
                    if (!it.contains("LEGGINGS")) {
                        n = 2;
                        continue block5;
                    }
                    if (Constants.WITHER_LEGGINGS_HEXES.containsKey(hex) && Constants.WITHER_LEGGINGS_HEXES.containsValue(it) && !Constants.WITHER_LEGGINGS_HEXES.get(hex).equals(it)) {
                        bl = true;
                        break block5;
                    }
                    bl = false;
                    break block5;
                }
                case 2: {
                    String it = string2;
                    if (!it.contains("BOOTS")) {
                        n = 3;
                        continue block5;
                    }
                    if (Constants.WITHER_BOOTS_HEXES.containsKey(hex) && Constants.WITHER_BOOTS_HEXES.containsValue(it) && !Constants.WITHER_BOOTS_HEXES.get(hex).equals(it)) {
                        bl = true;
                        break block5;
                    }
                    bl = false;
                    break block5;
                }
                default: {
                    bl = false;
                    break block5;
                }
            }
            break;
        }
        return bl;
    }

    private static enum DyeType implements class_3542
    {
        CRYSTAL("crystal", class_124.field_1075),
        FAIRY("fairy", class_124.field_1076),
        OG_FAIRY("og_fairy", class_124.field_1064),
        SPOOK("spook", class_124.field_1061),
        GLITCHED("glitched", class_124.field_1078),
        EXOTIC("exotic", class_124.field_1065);

        private final String name;
        private final class_124 formatting;

        private DyeType(String name, class_124 formatting) {
            this.name = name;
            this.formatting = formatting;
        }

        public String method_15434() {
            return this.name;
        }

        public class_5250 getTranslatedText() {
            return class_2561.method_43471((String)("skyblocker.exotic." + this.name)).method_27692(this.formatting);
        }
    }
}

