/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.tooltip.adders;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.item.tooltip.SimpleTooltipAdder;
import de.hysky.skyblocker.utils.BazaarProduct;
import de.hysky.skyblocker.utils.Formatters;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.RegexUtils;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.List;
import java.util.Locale;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class EssenceShopPrice
extends SimpleTooltipAdder {
    private static final Pattern ESSENCE_PATTERN = Pattern.compile("Cost (?<amount>[\\d,]+) (?<type>[A-Za-z]+) Essence");
    private static final String[] ESSENCE_TYPES = new String[]{"WITHER", "SPIDER", "UNDEAD", "DRAGON", "GOLD", "DIAMOND", "ICE", "CRIMSON"};
    private static final Object2LongArrayMap<String> ESSENCE_PRICES = new Object2LongArrayMap((Object[])ESSENCE_TYPES, new long[8]);

    public EssenceShopPrice(int priority) {
        super("\\S+ Essence Shop", priority);
    }

    public static void refreshEssencePrices(Object2ObjectMap<String, BazaarProduct> data) {
        for (String essenceType : ESSENCE_TYPES) {
            OptionalDouble sellPrice;
            BazaarProduct product = (BazaarProduct)data.get((Object)("ESSENCE_" + essenceType));
            if (product == null || !(sellPrice = product.sellPrice()).isPresent()) continue;
            ESSENCE_PRICES.put((Object)essenceType, (long)sellPrice.getAsDouble());
        }
    }

    @Override
    public void addToTooltip(@Nullable class_1735 focusedSlot, class_1799 stack, List<class_2561> lines) {
        String lore = ItemUtils.concatenateLore(lines);
        Matcher essenceMatcher = ESSENCE_PATTERN.matcher(lore);
        OptionalLong cost = RegexUtils.findLongFromMatcher(essenceMatcher);
        if (cost.isEmpty()) {
            return;
        }
        String type = essenceMatcher.group("type");
        long priceData = ESSENCE_PRICES.getLong((Object)type.toUpperCase(Locale.ROOT));
        if (priceData == 0L) {
            return;
        }
        lines.add((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Essence Cost:      ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)(Formatters.INTEGER_NUMBERS.format(priceData * cost.getAsLong()) + " coins")).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)(Formatters.INTEGER_NUMBERS.format(priceData) + " each")).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1080)));
    }

    @Override
    public boolean isEnabled() {
        return SkyblockerConfigManager.get().general.itemTooltip.showEssenceCost;
    }
}

