/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.museum;

import de.hysky.skyblocker.skyblock.museum.Donation;
import de.hysky.skyblocker.skyblock.museum.MuseumManager;
import de.hysky.skyblocker.skyblock.museum.PriceData;
import it.unimi.dsi.fastutil.objects.ObjectDoublePair;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7919;

public class ItemSorter {
    private SortMode currentSortMode = SortMode.LOWEST_BIN;
    private static final Consumer<List<Donation>> SORT_BY_LOWESTBIN = donations -> {
        donations.forEach(donation -> ItemSorter.updateDonationData(donation, false));
        donations.sort(ItemSorter::compareEffectivePrices);
    };
    private static final Consumer<List<Donation>> SORT_BY_CRAFTCOST = donations -> {
        donations.forEach(donation -> ItemSorter.updateDonationData(donation, true));
        donations.sort(ItemSorter::compareEffectivePrices);
    };
    private static final Consumer<List<Donation>> SORT_BY_XP_PER_COIN = donations -> {
        donations.forEach(donation -> ItemSorter.updateDonationData(donation, true));
        donations.sort(ItemSorter::compareCoinsPerXP);
    };

    public static void updateDonationData(Donation donation, boolean useCraftCost) {
        double ratio;
        double craftCost;
        List<String> downgrades = donation.getDowngrades();
        ObjectDoublePair<String> discount = donation.getDiscount();
        List willCountFor = downgrades.stream().map(MuseumManager::getDonation).filter(Objects::nonNull).collect(Collectors.toList());
        willCountFor.addFirst(donation);
        int totalXP = willCountFor.stream().mapToInt(Donation::getXp).sum();
        double lBinPrice = donation.getPriceData().getLBinPrice();
        double rawCraftCost = donation.isCraftable() ? donation.getPriceData().getCraftCost() : 0.0;
        double d2 = craftCost = discount != null ? rawCraftCost - discount.rightDouble() : rawCraftCost;
        double effectivePrice = useCraftCost ? (craftCost > 0.0 ? (lBinPrice == 0.0 ? craftCost : Math.min(craftCost, lBinPrice)) : lBinPrice) : (lBinPrice > 0.0 ? lBinPrice : craftCost);
        double d3 = ratio = totalXP > 0 && effectivePrice > 0.0 ? effectivePrice / (double)totalXP : 0.0;
        if (donation.isSet()) {
            donation.getSet().forEach(pair -> ((PriceData)pair.right()).setEffectivePrice(effectivePrice == craftCost ? ((PriceData)pair.right()).getCraftCost() : ((PriceData)pair.right()).getLBinPrice()));
        }
        donation.getPriceData().setEffectivePrice(effectivePrice);
        donation.setXpCoinsRatio(ratio);
        donation.setTotalXp(totalXP);
        donation.setCountsTowards(willCountFor.stream().map(d -> ObjectIntPair.of((Object)d.getId(), (int)d.getXp())).toList());
    }

    private static int compareEffectivePrices(Donation a, Donation b) {
        double priceA = a.getPriceData().getEffectivePrice();
        double priceB = b.getPriceData().getEffectivePrice();
        if (priceA <= 0.0 && priceB <= 0.0) {
            return Integer.compare(b.getTotalXp(), a.getTotalXp());
        }
        if (priceA <= 0.0) {
            return 1;
        }
        if (priceB <= 0.0) {
            return -1;
        }
        return Double.compare(priceA, priceB);
    }

    private static int compareCoinsPerXP(Donation a, Donation b) {
        double xpPerCoinA = a.getXpCoinsRatio();
        double xpPerCoinB = b.getXpCoinsRatio();
        if (xpPerCoinA == 0.0 && xpPerCoinB == 0.0) {
            return Integer.compare(b.getTotalXp(), a.getTotalXp());
        }
        if (xpPerCoinA == 0.0) {
            return 1;
        }
        if (xpPerCoinB == 0.0) {
            return -1;
        }
        return Double.compare(xpPerCoinA, xpPerCoinB);
    }

    public void cycleSortMode(List<Donation> donations) {
        this.currentSortMode = SortMode.values()[(this.currentSortMode.ordinal() + 1) % SortMode.values().length];
        this.applySort(donations);
    }

    public void applySort(List<Donation> donations) {
        this.currentSortMode.getSortFunction().accept(donations);
    }

    public class_1799 getCurrentSortingItem() {
        return this.currentSortMode.getAssociatedItem();
    }

    public class_7919 getTooltip() {
        class_5250 tooltip = class_2561.method_43471((String)"skyblocker.museum.hud.sorter").method_27693("\n\n").method_27692(class_124.field_1060).method_10852(this.getSortText(SortMode.LOWEST_BIN)).method_10852(this.getSortText(SortMode.CRAFT_COST)).method_10852(this.getSortText(SortMode.COINS_PER_XP)).method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"skyblocker.museum.hud.sorter.switch").method_27692(class_124.field_1054));
        return class_7919.method_47407((class_2561)tooltip);
    }

    private class_2561 getSortText(SortMode mode) {
        boolean isCurrent = mode == this.currentSortMode;
        return class_2561.method_43470((String)(isCurrent ? "\u27a4 " : "  ")).method_10852(mode.getDisplayName()).method_27693("\n").method_27692(isCurrent ? class_124.field_1075 : class_124.field_1080);
    }

    public static enum SortMode {
        LOWEST_BIN(new class_1799((class_1935)class_1802.field_8695), SORT_BY_LOWESTBIN, (class_2561)class_2561.method_43471((String)"skyblocker.museum.hud.sorter.lBin")),
        CRAFT_COST(new class_1799((class_1935)class_1802.field_8465), SORT_BY_CRAFTCOST, (class_2561)class_2561.method_43471((String)"skyblocker.museum.hud.sorter.craftCost")),
        COINS_PER_XP(new class_1799((class_1935)class_1802.field_8287), SORT_BY_XP_PER_COIN, (class_2561)class_2561.method_43471((String)"skyblocker.museum.hud.sorter.ratio"));

        private final class_1799 associatedItem;
        private final Consumer<List<Donation>> sortFunction;
        private final class_2561 displayName;

        private SortMode(class_1799 item, Consumer<List<Donation>> function, class_2561 displayName) {
            this.associatedItem = item;
            this.sortFunction = function;
            this.displayName = displayName;
        }

        public class_1799 getAssociatedItem() {
            return this.associatedItem;
        }

        public class_2561 getDisplayName() {
            return this.displayName;
        }

        public Consumer<List<Donation>> getSortFunction() {
            return this.sortFunction;
        }
    }
}

