/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.museum;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mojang.util.UndashedUuid;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.events.SkyblockEvents;
import de.hysky.skyblocker.skyblock.museum.Donation;
import de.hysky.skyblocker.skyblock.museum.MuseumManager;
import de.hysky.skyblocker.skyblock.museum.MuseumUtils;
import de.hysky.skyblocker.skyblock.museum.PriceData;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.Http;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.NEURepoManager;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.data.ProfiledData;
import io.github.moulberry.repo.NEURepoFile;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectDoublePair;
import it.unimi.dsi.fastutil.objects.ObjectObjectMutablePair;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_9322;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuseumItemCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuseumItemCache.class);
    private static final String ERROR_LOG_TEMPLATE = "[Skyblocker] Failed to refresh museum item data for profile {}";
    private static final int CONFIRM_DONATION_BUTTON_SLOT = 20;
    private static final String CONSTANTS_MUSEUM_DATA = "constants/museum.json";
    private static final Path CACHE_FILE = SkyblockerMod.CONFIG_DIR.resolve("museum_item_cache.json");
    private static final ProfiledData<ProfileMuseumData> MUSEUM_ITEM_CACHE = new ProfiledData<ProfileMuseumData>(CACHE_FILE, ProfileMuseumData.CODEC, true, true);
    public static final String DONATION_CONFIRMATION_SCREEN_TITLE = "Confirm Donation";
    public static final Map<String, String> ARMOR_NAMES = new Object2ObjectArrayMap();
    private static final Map<String, String> MAPPED_IDS = new Object2ObjectArrayMap();
    public static final ObjectArrayList<Donation> MUSEUM_DONATIONS = new ObjectArrayList();
    private static final ObjectArrayList<ObjectArrayList<String>> ORDERED_UPGRADES = new ObjectArrayList();
    private static final int CURRENT_DATA_VERSION = 1;

    @Init
    public static void init() {
        MuseumItemCache.loadMuseumItems();
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> MUSEUM_ITEM_CACHE.load());
        ClientCommandRegistrationCallback.EVENT.register(MuseumItemCache::registerCommands);
        SkyblockEvents.PROFILE_CHANGE.register((prev, profile) -> MuseumItemCache.onProfileChange());
    }

    private static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"museum").then(ClientCommandManager.literal((String)"resync").executes(context -> {
            FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
            class_5250 text = class_2561.method_43471((String)(MuseumItemCache.tryResync(source) ? "skyblocker.museum.attemptingResync" : "skyblocker.museum.cannotResync"));
            source.sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)text));
            return 1;
        }))));
    }

    public static void loadMuseumItems() {
        NEURepoManager.runAsyncAfterLoad(() -> {
            NEURepoFile filePath = NEURepoManager.file(CONSTANTS_MUSEUM_DATA);
            if (filePath == null) {
                return;
            }
            try (BufferedReader reader2 = Files.newBufferedReader(filePath.getFsPath());){
                JsonObject json = JsonParser.parseReader((Reader)reader2).getAsJsonObject();
                Map setExceptions = json.get("set_exceptions").getAsJsonObject().asMap();
                Map mappedIds = json.get("mapped_ids").getAsJsonObject().asMap();
                Map itemToXp = json.get("itemToXp").getAsJsonObject().asMap();
                Map setsToItems = json.get("sets_to_items").getAsJsonObject().asMap();
                Map children = json.get("children").getAsJsonObject().asMap();
                Map<String, JsonArray> allDonations = Map.of("weapons", json.get("weapons").getAsJsonArray(), "armor", json.get("armor").getAsJsonArray(), "rarities", json.get("rarities").getAsJsonArray());
                mappedIds.forEach((s, jsonElement) -> MAPPED_IDS.put((String)s, jsonElement.getAsString()));
                for (Map.Entry<String, JsonArray> entry : allDonations.entrySet()) {
                    String category = entry.getKey();
                    JsonArray array = entry.getValue();
                    for (JsonElement element : array) {
                        String itemID = element.getAsString();
                        ArrayList<ObjectObjectMutablePair<String, PriceData>> set = new ArrayList<ObjectObjectMutablePair<String, PriceData>>();
                        if (category.equals("armor")) {
                            boolean isEquipment = true;
                            for (JsonElement jsonElement2 : ((JsonElement)setsToItems.get(itemID)).getAsJsonArray()) {
                                if (isEquipment) {
                                    isEquipment = MuseumUtils.isEquipment(jsonElement2.getAsString());
                                }
                                set.add((ObjectObjectMutablePair<String, PriceData>)new ObjectObjectMutablePair((Object)jsonElement2.getAsString(), null));
                            }
                            String realId = setExceptions.entrySet().stream().filter(e -> ((JsonElement)e.getValue()).getAsString().equals(itemID)).map(Map.Entry::getKey).findFirst().orElse(itemID);
                            ARMOR_NAMES.put(itemID, MuseumUtils.formatArmorName(realId, isEquipment));
                        }
                        int itemXP = ((JsonElement)itemToXp.get(itemID)).getAsInt();
                        List<String> upgrades = MuseumItemCache.getUpgrades(children, itemID);
                        if (!upgrades.isEmpty()) {
                            Optional<ObjectArrayList> matchingUpgrade = ORDERED_UPGRADES.stream().filter(orderedUpgrade -> orderedUpgrade.contains((Object)itemID) || !Collections.disjoint(orderedUpgrade, upgrades)).findFirst();
                            if (matchingUpgrade.isPresent()) {
                                List orderedUpgrade2 = (List)matchingUpgrade.get();
                                if (orderedUpgrade2.size() <= upgrades.size()) {
                                    orderedUpgrade2.clear();
                                    orderedUpgrade2.add(itemID);
                                    orderedUpgrade2.addAll(upgrades);
                                }
                            } else {
                                ObjectArrayList newUpgrade = new ObjectArrayList();
                                newUpgrade.add((Object)itemID);
                                newUpgrade.addAll(upgrades);
                                ORDERED_UPGRADES.add((Object)newUpgrade);
                            }
                        }
                        MUSEUM_DONATIONS.add((Object)new Donation(category, itemID, set, itemXP));
                    }
                }
                MUSEUM_DONATIONS.forEach(donation -> {
                    for (List list : ORDERED_UPGRADES) {
                        int armorIndex = list.indexOf(donation.getId());
                        if (armorIndex <= 0) continue;
                        for (int i = armorIndex - 1; i >= 0; --i) {
                            donation.addDowngrade((String)list.get(i));
                        }
                    }
                });
                LOGGER.info("[Skyblocker] Loaded museum data");
            }
            catch (NoSuchFileException reader2) {
            }
            catch (IOException e2) {
                LOGGER.error("[Skyblocker] Failed to load donations data", (Throwable)e2);
            }
        });
    }

    public static List<String> getUpgrades(Map<String, JsonElement> children, String item) {
        ArrayList<String> upgrades = new ArrayList<String>();
        String currentItem = item;
        while (true) {
            String finalCurrentItem = currentItem;
            String parentItem = children.entrySet().stream().filter(e -> ((JsonElement)e.getValue()).getAsString().equals(finalCurrentItem)).map(Map.Entry::getKey).findFirst().orElse(null);
            if (parentItem == null) break;
            upgrades.add(parentItem);
            currentItem = parentItem;
        }
        return upgrades;
    }

    public static List<Donation> getDonations() {
        ArrayList<Donation> uncontributedItems = new ArrayList<Donation>();
        if (MUSEUM_ITEM_CACHE.containsKey()) {
            ObjectOpenHashSet<String> items = MUSEUM_ITEM_CACHE.get().collectedItemIds();
            for (Donation donation2 : MUSEUM_DONATIONS) {
                if (items.contains((Object)donation2.getId()) || donation2.isSet() && items.stream().anyMatch(i -> donation2.getSet().stream().anyMatch(p -> ((String)p.left()).equals(i)))) continue;
                donation2.setPriceData();
                uncontributedItems.add(donation2);
            }
            uncontributedItems.forEach(donation -> donation.setDiscount((ObjectDoublePair<String>)((ObjectDoublePair)donation.getDowngrades().stream().filter(downgrade -> donation.isCraftable()).filter(downgrade -> uncontributedItems.stream().noneMatch(item -> item.getId().equals(downgrade))).map(downgrade -> ObjectDoublePair.of((Object)downgrade, (double)MuseumUtils.getSetCraftCost(downgrade))).findFirst().orElse(null))));
            uncontributedItems.sort(Comparator.comparing(Donation::getId));
        }
        return uncontributedItems;
    }

    public static void handleClick(class_1735 ignoredSlot, int slotId, class_2371<class_1735> slots) {
        String profileId;
        if (slotId == 20 && !(profileId = Utils.getProfileId()).isEmpty()) {
            for (int i = 0; i < 17; ++i) {
                String setId;
                String itemId;
                class_1799 stack = ((class_1735)slots.get(i)).method_7677();
                if (stack.method_7960() || (itemId = ItemUtils.getItemId((class_9322)stack)).isEmpty()) continue;
                ProfileMuseumData data = MUSEUM_ITEM_CACHE.computeIfAbsent(ProfileMuseumData.EMPTY);
                if (MAPPED_IDS.containsKey(itemId)) {
                    itemId = MAPPED_IDS.get(itemId);
                }
                Donation donation = MuseumManager.getDonation((setId = MuseumUtils.getSetID(itemId)) != null ? setId : itemId);
                data.collectedItemIds().add((Object)itemId);
                if (setId != null) {
                    data.collectedItemIds().add((Object)setId);
                }
                if (donation == null || donation.getDowngrades().isEmpty()) continue;
                for (String downgrade : donation.getDowngrades()) {
                    if (donation.isSet()) {
                        List<String> pieces = MuseumUtils.getPiecesBySetID(downgrade);
                        data.collectedItemIds().addAll(pieces);
                    }
                    data.collectedItemIds().add((Object)downgrade);
                }
            }
            MUSEUM_ITEM_CACHE.save();
        }
    }

    private static void updateData4ProfileMember(UUID uuid, String profileId, @Nullable FabricClientCommandSource source) {
        CompletableFuture.runAsync(() -> {
            try (Http.ApiResponse response = Http.sendHypixelRequest("skyblock/museum", "?profile=" + profileId);){
                if (response.ok()) {
                    String uuidString;
                    JsonObject profileData = JsonParser.parseString((String)response.content()).getAsJsonObject();
                    JsonObject members = profileData.getAsJsonObject("members");
                    if (members.has(uuidString = UndashedUuid.toString((UUID)uuid))) {
                        JsonObject memberData = members.get(uuidString).getAsJsonObject();
                        Map donatedSets = memberData.get("items").getAsJsonObject().asMap();
                        ObjectOpenHashSet itemIds = new ObjectOpenHashSet();
                        donatedSets.forEach((s, __) -> {
                            Optional<Donation> donation = MUSEUM_DONATIONS.stream().filter(d -> d.getId().equals(s)).findFirst();
                            donation.ifPresent(value -> itemIds.addAll(value.getDowngrades()));
                            if (donation.isPresent()) {
                                if (donation.get().isSet()) {
                                    itemIds.addAll(donation.get().getSet().stream().map(ObjectObjectMutablePair::left).toList());
                                    donation.get().getDowngrades().forEach(downgrade -> itemIds.addAll(MuseumUtils.getPiecesBySetID(downgrade)));
                                } else {
                                    itemIds.add((Object)donation.get().getId().replace("STARRED_", ""));
                                    itemIds.addAll(donation.get().getDowngrades());
                                }
                            }
                        });
                        MUSEUM_ITEM_CACHE.put(uuid, profileId, new ProfileMuseumData(System.currentTimeMillis(), (ObjectOpenHashSet<String>)itemIds, 1));
                        MUSEUM_ITEM_CACHE.save();
                        if (source != null) {
                            source.sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.museum.resyncSuccess")));
                        }
                        LOGGER.info("[Skyblocker] Successfully updated museum item cache for profile {}", (Object)profileId);
                    } else {
                        MuseumItemCache.putEmpty(uuid, profileId);
                        if (source != null) {
                            source.sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.museum.resyncFailure")));
                        }
                        LOGGER.warn("[Skyblocker] Failed to refresh museum item data for profile {} because the Museum API is disabled!", (Object)profileId);
                    }
                } else {
                    MuseumItemCache.putEmpty(uuid, profileId);
                    if (source != null) {
                        source.sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.museum.resyncFailure")));
                    }
                    LOGGER.error("[Skyblocker] Failed to refresh museum item data for profile {} because a non 200 status code was encountered! Response: {}", (Object)profileId, (Object)response);
                }
            }
            catch (Exception e) {
                MuseumItemCache.putEmpty(uuid, profileId);
                if (source != null) {
                    source.sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.museum.resyncFailure")));
                }
                LOGGER.error(ERROR_LOG_TEMPLATE, (Object)profileId, (Object)e);
            }
        });
    }

    private static void putEmpty(UUID uuid, String profileId) {
        MUSEUM_ITEM_CACHE.computeIfAbsent(uuid, profileId, () -> new ProfileMuseumData(System.currentTimeMillis(), (ObjectOpenHashSet<String>)ObjectOpenHashSet.of(), 1));
        MUSEUM_ITEM_CACHE.save();
    }

    private static boolean tryResync(FabricClientCommandSource source) {
        if (MUSEUM_ITEM_CACHE.isLoaded()) {
            String profileId = Utils.getProfileId();
            if (profileId.isEmpty() || MUSEUM_ITEM_CACHE.containsKey() && !MUSEUM_ITEM_CACHE.get().canResync()) {
                return false;
            }
            MuseumItemCache.updateData4ProfileMember(Utils.getUuid(), profileId, source);
            return true;
        }
        return false;
    }

    public static void onProfileChange() {
        UUID uuid = Utils.getUuid();
        if (MUSEUM_ITEM_CACHE.isLoaded() && (!MUSEUM_ITEM_CACHE.containsKey() || MUSEUM_ITEM_CACHE.get().needsUpdate())) {
            MuseumItemCache.updateData4ProfileMember(uuid, Utils.getProfileId(), null);
        }
    }

    public static boolean hasItemInMuseum(String id) {
        return MUSEUM_ITEM_CACHE.containsKey() && MUSEUM_ITEM_CACHE.get().collectedItemIds().contains((Object)id.replace("STARRED_", ""));
    }

    private record ProfileMuseumData(long lastResync, ObjectOpenHashSet<String> collectedItemIds, int dataVersion) {
        private static final Supplier<ProfileMuseumData> EMPTY = () -> new ProfileMuseumData(0L, (ObjectOpenHashSet<String>)new ObjectOpenHashSet(), 1);
        private static final long TIME_BETWEEN_RESYNCING_ALLOWED = 600000L;
        private static final Codec<ProfileMuseumData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("lastResync").forGetter(ProfileMuseumData::lastResync), (App)Codec.STRING.listOf().xmap(ObjectOpenHashSet::new, ObjectArrayList::new).fieldOf("collectedItemIds").forGetter(ProfileMuseumData::collectedItemIds), (App)Codec.INT.optionalFieldOf("dataVersion", (Object)0).forGetter(ProfileMuseumData::dataVersion)).apply((Applicative)instance, ProfileMuseumData::new));

        private boolean canResync() {
            return this.lastResync + 600000L < System.currentTimeMillis();
        }

        private boolean needsUpdate() {
            return this.dataVersion < 1;
        }
    }
}

