/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.profileviewer;

import com.google.gson.JsonObject;
import de.hysky.skyblocker.skyblock.profileviewer.inventory.itemLoaders.BackpackItemLoader;
import de.hysky.skyblocker.skyblock.profileviewer.inventory.itemLoaders.InventoryItemLoader;
import de.hysky.skyblocker.skyblock.profileviewer.inventory.itemLoaders.ItemLoader;
import de.hysky.skyblocker.skyblock.profileviewer.inventory.itemLoaders.PetsInventoryItemLoader;
import de.hysky.skyblocker.skyblock.profileviewer.inventory.itemLoaders.WardrobeInventoryItemLoader;
import de.hysky.skyblocker.skyblock.profileviewer.utils.ProfileViewerUtils;
import de.hysky.skyblocker.skyblock.tabhud.util.Ico;
import de.hysky.skyblocker.utils.networth.NetworthCalculator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import org.joml.Matrix3x2fStack;

public class ProfileViewerTextWidget {
    private static final int ROW_GAP = 9;
    private String PROFILE_NAME = "UNKNOWN";
    private int SKYBLOCK_LEVEL = 0;
    private double PURSE = 0.0;
    private double BANK = 0.0;
    private double NETWORTH = 0.0;
    private List<class_2561> networthTooltip = List.of();

    public ProfileViewerTextWidget(JsonObject hypixelProfile, JsonObject playerProfile) {
        try {
            this.PROFILE_NAME = hypixelProfile.get("cute_name").getAsString();
            this.SKYBLOCK_LEVEL = playerProfile.getAsJsonObject("leveling").get("experience").getAsInt() / 100;
            this.PURSE = playerProfile.getAsJsonObject("currencies").get("coin_purse").getAsDouble();
            this.BANK = hypixelProfile.getAsJsonObject("banking").get("balance").getAsDouble();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.NETWORTH = this.PURSE + this.BANK + this.getItemsNetworth(playerProfile);
    }

    private double getItemsNetworth(JsonObject playerProfile) {
        double value = 0.0;
        PriorityQueue<ItemValue> top = new PriorityQueue<ItemValue>(Comparator.comparingDouble(ItemValue::price));
        try {
            JsonObject inventoryData = playerProfile.getAsJsonObject("inventory");
            if (inventoryData != null) {
                for (class_1799 stack : new InventoryItemLoader().loadItems(inventoryData)) {
                    value += this.addItemNetworth(top, stack);
                }
                if (inventoryData.has("ender_chest_contents")) {
                    for (class_1799 stack : new ItemLoader().loadItems(inventoryData.getAsJsonObject("ender_chest_contents"))) {
                        value += this.addItemNetworth(top, stack);
                    }
                }
                if (inventoryData.has("backpack_contents")) {
                    for (class_1799 stack : new BackpackItemLoader().loadItems(inventoryData.getAsJsonObject("backpack_contents"))) {
                        value += this.addItemNetworth(top, stack);
                    }
                }
                if (inventoryData.has("wardrobe_contents")) {
                    int activeSlot = inventoryData.get("wardrobe_equipped_slot").getAsInt();
                    HashSet<Integer> skip = new HashSet<Integer>();
                    if (activeSlot != -1) {
                        for (int i = 0; i < 4; ++i) {
                            int baseIndex = (activeSlot - 1) % 9;
                            int page = (activeSlot - 1) / 9;
                            int slotIndex = page * 36 + i * 9 + baseIndex;
                            skip.add(slotIndex);
                        }
                    }
                    WardrobeInventoryItemLoader loader = new WardrobeInventoryItemLoader(inventoryData);
                    List<class_1799> wardrobeItems = loader.loadItems(inventoryData.getAsJsonObject("wardrobe_contents"));
                    for (int index = 0; index < wardrobeItems.size(); ++index) {
                        if (skip.contains(index)) continue;
                        class_1799 stack = wardrobeItems.get(index);
                        value += this.addItemNetworth(top, stack);
                    }
                }
                if (inventoryData.has("bag_contents") && inventoryData.getAsJsonObject("bag_contents").has("talisman_bag")) {
                    for (class_1799 stack : new ItemLoader().loadItems(inventoryData.getAsJsonObject("bag_contents").getAsJsonObject("talisman_bag"))) {
                        value += this.addItemNetworth(top, stack);
                    }
                }
            }
            for (class_1799 stack : new PetsInventoryItemLoader().loadItems(playerProfile)) {
                value += this.addItemNetworth(top, stack);
            }
        }
        catch (Exception inventoryData) {
            // empty catch block
        }
        ArrayList<ItemValue> list = new ArrayList<ItemValue>(top);
        list.sort(Comparator.comparingDouble(ItemValue::price).reversed());
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        tooltip.add((class_2561)class_2561.method_43470((String)"Top Items:").method_27692(class_124.field_1065));
        for (ItemValue iv : list) {
            tooltip.add((class_2561)class_2561.method_43470((String)(iv.name + ": ")).method_10852((class_2561)class_2561.method_43470((String)ProfileViewerUtils.numLetterFormat(iv.price)).method_27692(class_124.field_1054)));
        }
        this.networthTooltip = tooltip;
        return value;
    }

    private double addItemNetworth(PriorityQueue<ItemValue> top, class_1799 stack) {
        double p = NetworthCalculator.getItemNetworth(stack).price();
        if (p > 0.0) {
            top.offer(new ItemValue(stack.method_7964().getString(), p));
            if (top.size() > 10) {
                top.poll();
            }
        }
        return p;
    }

    public void render(class_332 context, class_327 textRenderer, int root_x, int root_y, int mouseX, int mouseY) {
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        matrices.scale(0.75f, 0.75f);
        int rootAdjustedX = (int)((float)root_x / 0.75f);
        int rootAdjustedY = (int)((float)root_y / 0.75f);
        context.method_51427(Ico.PAINTING, rootAdjustedX, rootAdjustedY);
        matrices.popMatrix();
        context.method_51433(textRenderer, "\u00a7n" + this.PROFILE_NAME, root_x + 14, root_y + 3, -1, true);
        context.method_51433(textRenderer, "\u00a7aLevel:\u00a7r " + this.SKYBLOCK_LEVEL, root_x + 2, root_y + 6 + 9, -1, true);
        context.method_51433(textRenderer, "\u00a76Purse:\u00a7r " + ProfileViewerUtils.numLetterFormat(this.PURSE), root_x + 2, root_y + 6 + 18, -1, true);
        context.method_51433(textRenderer, "\u00a76Bank:\u00a7r " + ProfileViewerUtils.numLetterFormat(this.BANK), root_x + 2, root_y + 6 + 27, -1, true);
        String nwString = "\u00a76NW:\u00a7r " + ProfileViewerUtils.numLetterFormat(this.NETWORTH);
        int nwX = root_x + 2;
        int nwY = root_y + 6 + 36;
        context.method_51433(textRenderer, nwString, nwX, nwY, -1, true);
        if (mouseX >= nwX && mouseX <= nwX + textRenderer.method_1727(nwString) && mouseY >= nwY) {
            Objects.requireNonNull(textRenderer);
            if (mouseY <= nwY + 9) {
                context.method_51434(textRenderer, this.networthTooltip, mouseX, mouseY);
            }
        }
    }

    private record ItemValue(String name, double price) {
    }
}

