/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.profileviewer.dungeons;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.hysky.skyblocker.skyblock.tabhud.util.Ico;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Map;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class DungeonMiscStatsWidgets {
    private static final class_2960 TEXTURE = class_2960.method_60655((String)"skyblocker", (String)"textures/gui/profile_viewer/icon_data_widget.png");
    private static final class_2960 RUN_ICON = class_2960.method_60655((String)"skyblocker", (String)"textures/gui/profile_viewer/run_icon.png");
    private static final class_327 textRenderer = class_310.method_1551().field_1772;
    private static final DecimalFormat DF = new DecimalFormat("#.##");
    private static final String[] DUNGEONS = new String[]{"catacombs", "master_catacombs"};
    private final Object2IntMap<String> dungeonRuns = new Object2IntOpenHashMap();
    private int secrets = 0;
    private int totalRuns = 0;

    public DungeonMiscStatsWidgets(JsonObject pProfile) {
        JsonObject DUNGEONS_DATA = pProfile.getAsJsonObject("dungeons");
        try {
            this.secrets = DUNGEONS_DATA.get("secrets").getAsInt();
            for (String dungeon : DUNGEONS) {
                JsonObject dungeonData = DUNGEONS_DATA.getAsJsonObject("dungeon_types").getAsJsonObject(dungeon).getAsJsonObject("tier_completions");
                int runs = 0;
                for (Map.Entry entry : dungeonData.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("total")) continue;
                    runs += ((JsonElement)entry.getValue()).getAsInt();
                }
                this.dungeonRuns.put((Object)dungeon, runs);
                this.totalRuns += runs;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void render(class_332 context, int x, int y) {
        context.method_25290(class_10799.field_56883, TEXTURE, x, y, 0.0f, 0.0f, 109, 26, 109, 26);
        context.method_51427(Ico.FEATHER, x + 2, y + 4);
        context.method_51433(textRenderer, "Secrets " + this.secrets, x + 30, y + 4, Color.WHITE.getRGB(), true);
        context.method_51433(textRenderer, "Avg " + String.valueOf(this.totalRuns > 0 ? DF.format((float)this.secrets / (float)this.totalRuns) : Integer.valueOf(0)) + "/Run", x + 30, y + 14, Color.WHITE.getRGB(), true);
        context.method_25290(class_10799.field_56883, TEXTURE, x, y + 28, 0.0f, 0.0f, 109, 26, 109, 26);
        context.method_25290(class_10799.field_56883, RUN_ICON, x + 4, y + 33, 0.0f, 0.0f, 14, 16, 14, 16);
        context.method_51433(textRenderer, "\u00a7aNormal \u00a7r" + this.dungeonRuns.getOrDefault((Object)"catacombs", 0), x + 30, y + 32, Color.WHITE.getRGB(), true);
        context.method_51433(textRenderer, "\u00a7cMaster \u00a7r" + this.dungeonRuns.getOrDefault((Object)"master_catacombs", 0), x + 30, y + 42, Color.WHITE.getRGB(), true);
    }
}

