/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.profileviewer.skills;

import de.hysky.skyblocker.skyblock.profileviewer.utils.LevelFinder;
import de.hysky.skyblocker.skyblock.profileviewer.utils.ProfileViewerUtils;
import de.hysky.skyblocker.skyblock.tabhud.util.Ico;
import de.hysky.skyblocker.utils.Formatters;
import de.hysky.skyblocker.utils.render.HudHelper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;

public class SkillWidget {
    private final String SKILL_NAME;
    private final LevelFinder.LevelInfo SKILL_LEVEL;
    private static final class_2960 BAR_FILL = class_2960.method_60655((String)"skyblocker", (String)"bars/bar_fill");
    private static final class_2960 BAR_BACK = class_2960.method_60655((String)"skyblocker", (String)"bars/bar_back");
    private final class_1799 stack;
    private static final class_327 textRenderer = class_310.method_1551().field_1772;
    private static final Map<String, class_1799> SKILL_LOGO = Map.ofEntries(Map.entry("Combat", Ico.STONE_SWORD), Map.entry("Farming", Ico.GOLDEN_HOE), Map.entry("Mining", Ico.STONE_PICKAXE), Map.entry("Foraging", Ico.JUNGLE_SAPLING), Map.entry("Fishing", Ico.FISH_ROD), Map.entry("Enchanting", Ico.ENCHANTING_TABLE), Map.entry("Alchemy", Ico.BREWING_STAND), Map.entry("Taming", Ico.SPAWN_EGG), Map.entry("Carpentry", Ico.CRAFTING_TABLE), Map.entry("Catacombs", ProfileViewerUtils.createSkull("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHBzOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlLzliNTY4OTViOTY1OTg5NmFkNjQ3ZjU4NTk5MjM4YWY1MzJkNDZkYjljMWIwMzg5YjhiYmViNzA5OTlkYWIzM2QifX19")), Map.entry("Runecraft", Ico.MAGMA_CREAM), Map.entry("Social", Ico.EMERALD));
    private static final Object2IntMap<String> SKILL_CAP = Object2IntMaps.unmodifiable((Object2IntMap)new Object2IntOpenHashMap(Map.ofEntries(Map.entry("Combat", 60), Map.entry("Farming", 60), Map.entry("Mining", 60), Map.entry("Foraging", 50), Map.entry("Fishing", 50), Map.entry("Enchanting", 60), Map.entry("Alchemy", 50), Map.entry("Taming", 60), Map.entry("Carpentry", 50), Map.entry("Catacombs", 50), Map.entry("Runecraft", 25), Map.entry("Social", 25))));
    private static final Object2IntMap<String> SOFT_SKILL_CAP = Object2IntMaps.unmodifiable((Object2IntMap)new Object2IntOpenHashMap(Map.of("Taming", 50, "Farming", 50)));
    private static final Object2IntMap<String> INFINITE = Object2IntMaps.singleton((Object)"Catacombs", (int)0);

    public SkillWidget(String skill, long xp, int playerCap) {
        this.SKILL_NAME = skill;
        this.SKILL_LEVEL = LevelFinder.getLevelInfo(skill, xp);
        if (this.SKILL_LEVEL.level >= SKILL_CAP.getInt((Object)skill) && !INFINITE.containsKey((Object)skill)) {
            this.SKILL_LEVEL.fill = 1.0;
            this.SKILL_LEVEL.level = SKILL_CAP.getInt((Object)skill);
        }
        this.stack = SKILL_LOGO.getOrDefault(skill, Ico.BARRIER);
        if (playerCap != -1) {
            this.SKILL_LEVEL.level = Math.min(this.SKILL_LEVEL.level, SOFT_SKILL_CAP.getInt((Object)this.SKILL_NAME) + playerCap);
        }
    }

    public void render(class_332 context, int mouseX, int mouseY, int x, int y) {
        context.method_51427(this.stack, x + 3, y + 2);
        context.method_51433(textRenderer, this.SKILL_NAME + " " + this.SKILL_LEVEL.level, x + 31, y + 2, Color.white.hashCode(), false);
        Color fillColor = Color.green;
        if (this.SKILL_LEVEL.level >= SKILL_CAP.getInt((Object)this.SKILL_NAME)) {
            fillColor = Color.MAGENTA;
        }
        if (SOFT_SKILL_CAP.containsKey((Object)this.SKILL_NAME) && this.SKILL_LEVEL.level > SOFT_SKILL_CAP.getInt((Object)this.SKILL_NAME) && this.SKILL_LEVEL.level < SKILL_CAP.getInt((Object)this.SKILL_NAME) && this.SKILL_LEVEL.fill == 1.0) {
            fillColor = Color.YELLOW;
        }
        context.method_52706(class_10799.field_56883, BAR_BACK, x + 30, y + 12, 75, 6);
        HudHelper.renderNineSliceColored(context, BAR_FILL, x + 30, y + 12, (int)(75.0 * this.SKILL_LEVEL.fill), 6, fillColor);
        if (mouseX > x + 30 && mouseX < x + 105 && mouseY > y + 10 && mouseY < y + 19) {
            ArrayList<class_5250> tooltipText = new ArrayList<class_5250>();
            tooltipText.add(class_2561.method_43470((String)this.SKILL_NAME).method_27692(class_124.field_1060));
            tooltipText.add(class_2561.method_43470((String)("XP: " + Formatters.INTEGER_NUMBERS.format(this.SKILL_LEVEL.xp))).method_27692(class_124.field_1065));
            context.method_51434(textRenderer, tooltipText, mouseX, mouseY);
        }
    }
}

