/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.quicknav;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.QuickNavigationConfig;
import de.hysky.skyblocker.skyblock.quicknav.QuickNavButton;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.datafixer.ItemStackComponentizationFixer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickNav {
    static final Logger LOGGER = LoggerFactory.getLogger(QuickNav.class);

    public static List<QuickNavButton> init(String screenTitle) {
        ArrayList<QuickNavButton> buttons = new ArrayList<QuickNavButton>();
        QuickNavigationConfig data = SkyblockerConfigManager.get().quickNav;
        try {
            if (data.button1.render) {
                buttons.add(QuickNav.parseButton(data.button1, screenTitle, 0));
            }
            if (data.button2.render) {
                buttons.add(QuickNav.parseButton(data.button2, screenTitle, 1));
            }
            if (data.button3.render) {
                buttons.add(QuickNav.parseButton(data.button3, screenTitle, 2));
            }
            if (data.button4.render) {
                buttons.add(QuickNav.parseButton(data.button4, screenTitle, 3));
            }
            if (data.button5.render) {
                buttons.add(QuickNav.parseButton(data.button5, screenTitle, 4));
            }
            if (data.button6.render) {
                buttons.add(QuickNav.parseButton(data.button6, screenTitle, 5));
            }
            if (data.button7.render) {
                buttons.add(QuickNav.parseButton(data.button7, screenTitle, 6));
            }
            if (data.button8.render) {
                buttons.add(QuickNav.parseButton(data.button8, screenTitle, 7));
            }
            if (data.button9.render) {
                buttons.add(QuickNav.parseButton(data.button9, screenTitle, 8));
            }
            if (data.button10.render) {
                buttons.add(QuickNav.parseButton(data.button10, screenTitle, 9));
            }
            if (data.button11.render) {
                buttons.add(QuickNav.parseButton(data.button11, screenTitle, 10));
            }
            if (data.button12.render) {
                buttons.add(QuickNav.parseButton(data.button12, screenTitle, 11));
            }
            if (data.button13.render) {
                buttons.add(QuickNav.parseButton(data.button13, screenTitle, 12));
            }
            if (data.button14.render) {
                buttons.add(QuickNav.parseButton(data.button14, screenTitle, 13));
            }
        }
        catch (CommandSyntaxException e) {
            LOGGER.error("[Skyblocker] Failed to initialize Quick Nav Button", (Throwable)e);
        }
        return buttons;
    }

    private static QuickNavButton parseButton(QuickNavigationConfig.QuickNavItem buttonInfo, String screenTitle, int id) throws CommandSyntaxException {
        boolean uiTitleMatches;
        class_1799 stack;
        block2: {
            QuickNavigationConfig.ItemData itemData = buttonInfo.itemData;
            stack = itemData != null && itemData.item != null && itemData.components != null ? ItemStackComponentizationFixer.fromComponentsString(itemData.item.toString(), Math.clamp((long)itemData.count, 1, 99), itemData.components) : new class_1799((class_1935)class_1802.field_8077);
            uiTitleMatches = false;
            try {
                uiTitleMatches = screenTitle.matches(buttonInfo.uiTitle);
            }
            catch (PatternSyntaxException e) {
                LOGGER.error("[Skyblocker] Failed to parse Quick Nav Button with regex: {}", (Object)buttonInfo.uiTitle, (Object)e);
                class_746 player = class_310.method_1551().field_1724;
                if (player == null) break block2;
                player.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43470((String)("Invalid regex in Quick Nav Button " + (id + 1) + "!")).method_27692(class_124.field_1061)), false);
            }
        }
        return new QuickNavButton(id, uiTitleMatches, buttonInfo.clickEvent, stack, buttonInfo.tooltip);
    }
}

