/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.searchoverlay;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.UIAndVisualsConfig;
import de.hysky.skyblocker.skyblock.item.tooltip.info.TooltipInfoType;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.skyblock.searchoverlay.OverlayScreen;
import de.hysky.skyblocker.utils.BazaarProduct;
import de.hysky.skyblocker.utils.NEURepoManager;
import de.hysky.skyblocker.utils.RomanNumerals;
import de.hysky.skyblocker.utils.scheduler.MessageScheduler;
import io.github.moulberry.repo.data.NEUItem;
import io.github.moulberry.repo.util.NEUId;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2625;
import net.minecraft.class_2877;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_7157;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchOverManager {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Skyblocker Search Overlay");
    private static final Pattern BAZAAR_ENCHANTMENT_PATTERN = Pattern.compile("Enchantment (\\D*) (\\d+)");
    private static final String PET_NAME_START = "[Lvl {LVL}] ";
    @Nullable
    private static class_2625 sign = null;
    private static boolean signFront = true;
    protected static boolean isAuction;
    private static boolean isCommand;
    protected static String search;
    protected static Boolean maxPetLevel;
    protected static int dungeonStars;
    private static HashSet<String> bazaarItems;
    private static HashSet<String> auctionItems;
    private static HashSet<String> auctionPets;
    private static HashSet<String> starableItems;
    private static HashMap<String, String> namesToNeuId;
    public static String[] suggestionsArray;

    @Init
    public static void init() {
        ClientCommandRegistrationCallback.EVENT.register(SearchOverManager::registerSearchCommands);
        NEURepoManager.runAsyncAfterLoad(SearchOverManager::loadItems);
    }

    private static void registerSearchCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        if (SkyblockerConfigManager.get().uiAndVisuals.searchOverlay.enableCommands) {
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"ahs").executes(context -> SearchOverManager.startCommand(true, "")));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"bzs").executes(context -> SearchOverManager.startCommand(false, "")));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"ahs").then(ClientCommandManager.argument((String)"item", (ArgumentType)StringArgumentType.greedyString()).executes(context -> SearchOverManager.startCommand(true, StringArgumentType.getString((CommandContext)context, (String)"item")))));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"bzs").then(ClientCommandManager.argument((String)"item", (ArgumentType)StringArgumentType.greedyString()).executes(context -> SearchOverManager.startCommand(false, StringArgumentType.getString((CommandContext)context, (String)"item")))));
        }
    }

    private static int startCommand(boolean isAuction, String itemName) {
        isCommand = true;
        SearchOverManager.isAuction = isAuction;
        search = "";
        suggestionsArray = new String[0];
        if (!itemName.isEmpty()) {
            SearchOverManager.updateSearch(itemName);
        }
        CLIENT.method_63588(() -> CLIENT.method_1507((class_437)new OverlayScreen()));
        return 1;
    }

    private static void loadItems() {
        Object name;
        HashSet<Object> bazaarItems = new HashSet<Object>();
        HashSet<String> auctionItems = new HashSet<String>();
        HashSet<String> auctionPets = new HashSet<String>();
        HashSet<String> starableItems = new HashSet<String>();
        HashMap<Object, String> namesToNeuId = new HashMap<Object, String>();
        try {
            if (TooltipInfoType.BAZAAR.getData() == null) {
                TooltipInfoType.BAZAAR.run();
            }
            Object2ObjectMap<String, BazaarProduct> products = TooltipInfoType.BAZAAR.getData();
            for (Map.Entry entry : products.entrySet()) {
                NEUItem neuItem;
                BazaarProduct product = (BazaarProduct)entry.getValue();
                String id = product.id();
                name = product.name();
                int sellVolume = product.sellVolume();
                if (sellVolume == 0) continue;
                Matcher matcher = BAZAAR_ENCHANTMENT_PATTERN.matcher((CharSequence)name);
                if (matcher.matches() && ItemRepository.getBazaarStocks().containsKey(id)) {
                    name = matcher.group(1);
                    if (!((String)name).contains("Ultimate Wise") && !((String)name).contains("Ultimate Jerry")) {
                        name = ((String)name).replace("Ultimate ", "");
                    }
                    if (((String)name).startsWith("Turbo ")) {
                        name = ((String)name).replace("Turbo ", "Turbo-");
                    }
                    String level = matcher.group(2);
                    name = (String)name + " " + RomanNumerals.decimalToRoman(Integer.parseInt(level));
                    bazaarItems.add(name);
                    namesToNeuId.put(name, ItemRepository.getBazaarStocks().get(id));
                    continue;
                }
                if (id.startsWith("SHARD_") && ItemRepository.getBazaarStocks().containsKey(id)) {
                    id = ItemRepository.getBazaarStocks().get(id);
                }
                if ((neuItem = NEURepoManager.getItemByNeuId(id)) == null) continue;
                name = class_124.method_539((String)neuItem.getDisplayName());
                bazaarItems.add(name);
                namesToNeuId.put(name, id);
            }
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker] Failed to load bazaar item list! ", (Throwable)e);
        }
        try {
            Set<@NEUId K> essenceCosts = NEURepoManager.getConstants().getEssenceCost().getCosts().keySet();
            if (TooltipInfoType.THREE_DAY_AVERAGE.getData() == null) {
                TooltipInfoType.THREE_DAY_AVERAGE.run();
            }
            for (Map.Entry entry : TooltipInfoType.THREE_DAY_AVERAGE.getData().object2DoubleEntrySet()) {
                String id = (String)entry.getKey();
                NEUItem neuItem = NEURepoManager.getItemByNeuId(id = id.split("[+-]")[0]);
                if (neuItem == null) continue;
                name = class_124.method_539((String)neuItem.getDisplayName());
                if (name != null && ((String)name).startsWith(PET_NAME_START)) {
                    name = ((String)name).replace(PET_NAME_START, "");
                    auctionPets.add(((String)name).toLowerCase());
                }
                if (name != null && essenceCosts.contains(neuItem.getSkyblockItemId())) {
                    starableItems.add(((String)name).toLowerCase());
                }
                auctionItems.add((String)name);
                namesToNeuId.put(name, id);
            }
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker] Failed to load auction house item list! ", (Throwable)e);
        }
        SearchOverManager.bazaarItems = bazaarItems;
        SearchOverManager.auctionItems = auctionItems;
        SearchOverManager.auctionPets = auctionPets;
        SearchOverManager.starableItems = starableItems;
        SearchOverManager.namesToNeuId = namesToNeuId;
    }

    public static void updateSign(@NotNull class_2625 sign, boolean front, boolean isAuction) {
        signFront = front;
        SearchOverManager.sign = sign;
        isCommand = false;
        SearchOverManager.isAuction = isAuction;
        if (SkyblockerConfigManager.get().uiAndVisuals.searchOverlay.keepPreviousSearches) {
            class_2561[] messages = SearchOverManager.sign.method_49843(signFront).method_49877(CLIENT.method_33883());
            search = messages[0].getString();
            if (!messages[1].getString().isEmpty()) {
                if (!search.endsWith(" ")) {
                    search = search + " ";
                }
                search = search + messages[1].getString();
            }
        } else {
            search = "";
        }
        suggestionsArray = new String[0];
    }

    protected static void updateSearch(String newValue) {
        search = newValue;
        int totalSuggestions = SkyblockerConfigManager.get().uiAndVisuals.searchOverlay.maxSuggestions;
        if (newValue.isBlank() || totalSuggestions == 0) {
            return;
        }
        suggestionsArray = (String[])(isAuction ? auctionItems : bazaarItems).stream().sorted(Comparator.comparing(SearchOverManager::shouldFrontLoad, Comparator.reverseOrder())).filter(item -> item.toLowerCase().contains(search.toLowerCase())).limit(totalSuggestions).toArray(String[]::new);
    }

    private static boolean shouldFrontLoad(String name) {
        if (!isAuction) {
            return false;
        }
        if (!auctionPets.contains(name.toLowerCase())) {
            return false;
        }
        return (double)search.length() / (double)name.length() > 0.5;
    }

    protected static String getSuggestion(int index) {
        if (suggestionsArray.length > index && suggestionsArray[index] != null) {
            return suggestionsArray[index];
        }
        return "";
    }

    protected static String getSuggestionId(int index) {
        return namesToNeuId.get(SearchOverManager.getSuggestion(index));
    }

    protected static String getHistory(int index) {
        if (isAuction) {
            if (SkyblockerConfigManager.get().uiAndVisuals.searchOverlay.auctionHistory.size() > index) {
                return SkyblockerConfigManager.get().uiAndVisuals.searchOverlay.auctionHistory.get(index);
            }
        } else if (SkyblockerConfigManager.get().uiAndVisuals.searchOverlay.bazaarHistory.size() > index) {
            return SkyblockerConfigManager.get().uiAndVisuals.searchOverlay.bazaarHistory.get(index);
        }
        return null;
    }

    protected static String getHistoryId(int index) {
        return namesToNeuId.get(SearchOverManager.getHistory(index));
    }

    protected static void removeHistoryItem(int index) {
        UIAndVisualsConfig.SearchOverlay config = SkyblockerConfigManager.get().uiAndVisuals.searchOverlay;
        if (isAuction) {
            if (config.auctionHistory.size() > index) {
                config.auctionHistory.remove(index);
            }
        } else if (config.bazaarHistory.size() > index) {
            config.bazaarHistory.remove(index);
        }
    }

    private static void saveHistory() {
        UIAndVisualsConfig.SearchOverlay config = SkyblockerConfigManager.get().uiAndVisuals.searchOverlay;
        if (isAuction) {
            if (config.auctionHistory.isEmpty() || !config.auctionHistory.contains(search)) {
                config.auctionHistory.addFirst(search);
                if (config.auctionHistory.size() > config.historyLength) {
                    config.auctionHistory = config.auctionHistory.subList(0, config.historyLength);
                }
            } else {
                config.auctionHistory.remove(search);
                config.auctionHistory.addFirst(search);
            }
        } else if (config.bazaarHistory.isEmpty() || !config.bazaarHistory.contains(search)) {
            config.bazaarHistory.addFirst(search);
            if (config.bazaarHistory.size() > config.historyLength) {
                config.bazaarHistory = config.bazaarHistory.subList(0, config.historyLength);
            }
        } else {
            config.bazaarHistory.remove(search);
            config.bazaarHistory.addFirst(search);
        }
        SkyblockerConfigManager.save();
    }

    protected static void pushSearch() {
        if (!search.isEmpty()) {
            SearchOverManager.saveHistory();
        }
        if (isAuction) {
            SearchOverManager.addExtras();
        }
        if (!isAuction && !isCommand && search.toLowerCase().contains("null")) {
            search = "\"%s\"".formatted(search);
        }
        if (isCommand) {
            SearchOverManager.pushCommand();
        } else {
            SearchOverManager.pushSign();
        }
    }

    private static void addExtras() {
        if (maxPetLevel.booleanValue()) {
            if (auctionPets.contains(search.toLowerCase())) {
                search = search.equalsIgnoreCase("golden dragon") || search.equalsIgnoreCase("jade dragon") ? "[Lvl 200] " + search : "[Lvl 100] " + search;
            }
        } else if (auctionPets.contains(search.toLowerCase())) {
            search = "] " + search;
        }
        if (dungeonStars > 0 && starableItems.contains(search.toLowerCase())) {
            StringBuilder starString = new StringBuilder(" ");
            starString.append("\u272a".repeat(Math.max(0, Math.min(dungeonStars, 5))));
            switch (dungeonStars) {
                case 6: {
                    starString.append("\u278a");
                    break;
                }
                case 7: {
                    starString.append("\u278b");
                    break;
                }
                case 8: {
                    starString.append("\u278c");
                    break;
                }
                case 9: {
                    starString.append("\u278d");
                    break;
                }
                case 10: {
                    starString.append("\u278e");
                }
            }
            search = search + starString.toString();
        }
    }

    private static void pushCommand() {
        if (search.isEmpty()) {
            return;
        }
        String command = isAuction ? "/ahSearch " + search : "/bz " + search;
        MessageScheduler.INSTANCE.sendMessageAfterCooldown(command, true);
    }

    private static void pushSign() {
        Pair<String, String> split = SearchOverManager.splitString(search);
        if (SearchOverManager.CLIENT.field_1724 != null && sign != null) {
            class_2561[] messages = sign.method_49843(signFront).method_49877(CLIENT.method_33883());
            SearchOverManager.CLIENT.field_1724.field_3944.method_52787((class_2596)new class_2877(sign.method_11016(), signFront, (String)split.left(), (String)split.right(), messages[2].getString(), messages[3].getString()));
        }
    }

    public static Pair<String, String> splitString(String s) {
        if (s.length() <= 15) {
            return Pair.of((Object)s, (Object)"");
        }
        int index = s.lastIndexOf(32, 15);
        if (index == -1) {
            return Pair.of((Object)s.substring(0, 15), (Object)"");
        }
        return Pair.of((Object)s.substring(0, index), (Object)s.substring(index + 1, Math.min(index + 16, s.length())).trim());
    }

    static {
        search = "";
        maxPetLevel = false;
        dungeonStars = 0;
        bazaarItems = new HashSet();
        auctionItems = new HashSet();
        auctionPets = new HashSet();
        starableItems = new HashSet();
        namesToNeuId = new HashMap();
        suggestionsArray = new String[0];
    }
}

