/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.slayers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.slayers.SlayerManager;
import de.hysky.skyblocker.skyblock.slayers.SlayerTier;
import de.hysky.skyblocker.skyblock.slayers.SlayerType;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.data.ProfiledData;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class SlayerTimer {
    private static final Path FILE = SkyblockerMod.CONFIG_DIR.resolve("slayer_personal_best.json");
    private static final ProfiledData<Object2ObjectOpenHashMap<SlayerType, Object2ObjectOpenHashMap<SlayerTier, SlayerInfo>>> CACHED_SLAYER_STATS = new ProfiledData<Object2ObjectOpenHashMap<SlayerType, Object2ObjectOpenHashMap<SlayerTier, SlayerInfo>>>(FILE, SlayerInfo.SERIALIZATION_CODEC, true, true);

    @Init
    public static void init() {
        CACHED_SLAYER_STATS.load();
    }

    public static void onBossDeath(Instant startTime) {
        if (!SkyblockerConfigManager.get().slayers.slainTime || startTime == null) {
            return;
        }
        Instant slainTime = Instant.now();
        long timeElapsed = Duration.between(startTime, slainTime).toMillis();
        String duration = SlayerTimer.formatTime(timeElapsed);
        long currentPB = SlayerTimer.getPersonalBest(SlayerManager.getSlayerType(), SlayerManager.getSlayerTier());
        if (currentPB != -1L && currentPB > timeElapsed) {
            class_310.method_1551().field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.slayer.slainTime", (Object[])new Object[]{class_2561.method_43470((String)duration).method_27692(class_124.field_1054)}).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"skyblocker.slayer.personalBest").method_27692(class_124.field_1076))), false);
            class_310.method_1551().field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.slayer.previousPB", (Object[])new Object[]{class_2561.method_43470((String)SlayerTimer.formatTime(currentPB)).method_27692(class_124.field_1054)})), false);
            SlayerTimer.updateBestTime(SlayerManager.getSlayerType(), SlayerManager.getSlayerTier(), timeElapsed);
        } else {
            class_310.method_1551().field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.slayer.slainTime", (Object[])new Object[]{class_2561.method_43470((String)duration).method_27692(class_124.field_1054)})), false);
            if (currentPB == -1L) {
                SlayerTimer.updateBestTime(SlayerManager.getSlayerType(), SlayerManager.getSlayerTier(), timeElapsed);
            }
        }
    }

    private static long getPersonalBest(SlayerType slayerType, SlayerTier slayerTier) {
        Object2ObjectOpenHashMap profileData = CACHED_SLAYER_STATS.computeIfAbsent(Object2ObjectOpenHashMap::new);
        Object2ObjectOpenHashMap typeData = (Object2ObjectOpenHashMap)profileData.computeIfAbsent((Object)slayerType, _type -> new Object2ObjectOpenHashMap());
        SlayerInfo currentBest = (SlayerInfo)typeData.get((Object)slayerTier);
        return currentBest != null ? currentBest.bestTimeMillis : -1L;
    }

    private static void updateBestTime(SlayerType slayerType, SlayerTier slayerTier, long timeElapsed) {
        long nowMillis = System.currentTimeMillis();
        Object2ObjectOpenHashMap profileData = CACHED_SLAYER_STATS.computeIfAbsent(Object2ObjectOpenHashMap::new);
        Object2ObjectOpenHashMap typeData = (Object2ObjectOpenHashMap)profileData.computeIfAbsent((Object)slayerType, _type -> new Object2ObjectOpenHashMap());
        SlayerInfo newInfo = new SlayerInfo(timeElapsed, nowMillis);
        typeData.put((Object)slayerTier, (Object)newInfo);
        CACHED_SLAYER_STATS.save();
    }

    private static String formatTime(long millis) {
        return String.format("%.2fs", (double)millis / 1000.0);
    }

    public record SlayerInfo(long bestTimeMillis, long dateMillis) {
        public static final Codec<SlayerInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("bestTimeMillis").forGetter(SlayerInfo::bestTimeMillis), (App)Codec.LONG.fieldOf("dateMillis").forGetter(SlayerInfo::dateMillis)).apply((Applicative)instance, SlayerInfo::new));
        private static final Codec<Object2ObjectOpenHashMap<SlayerType, Object2ObjectOpenHashMap<SlayerTier, SlayerInfo>>> SERIALIZATION_CODEC = Codec.unboundedMap(SlayerType.CODEC, (Codec)Codec.unboundedMap(SlayerTier.CODEC, CODEC).xmap(Object2ObjectOpenHashMap::new, Function.identity())).xmap(Object2ObjectOpenHashMap::new, Function.identity());
    }
}

