/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.slayers.hud;

import de.hysky.skyblocker.annotations.RegisterWidget;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.slayers.SlayerManager;
import de.hysky.skyblocker.skyblock.slayers.SlayerTier;
import de.hysky.skyblocker.skyblock.slayers.SlayerType;
import de.hysky.skyblocker.skyblock.tabhud.config.WidgetsConfigurationScreen;
import de.hysky.skyblocker.skyblock.tabhud.util.Ico;
import de.hysky.skyblocker.skyblock.tabhud.widget.ComponentBasedWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.IcoTextComponent;
import de.hysky.skyblocker.utils.Formatters;
import de.hysky.skyblocker.utils.Location;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;

@RegisterWidget
public class SlayerHudWidget
extends ComponentBasedWidget {
    private static final Set<Location> AVAILABLE_LOCATIONS = Set.of(Location.CRIMSON_ISLE, Location.HUB, Location.SPIDERS_DEN, Location.THE_END, Location.THE_PARK, Location.THE_RIFT);
    private static SlayerHudWidget instance;
    private final class_310 client = class_310.method_1551();

    public SlayerHudWidget() {
        super(class_2561.method_43470((String)"Slayer").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067}), class_124.field_1064.method_532(), "hud_slayer");
        instance = this;
        this.update();
    }

    @Override
    public boolean shouldUpdateBeforeRendering() {
        return true;
    }

    public static SlayerHudWidget getInstance() {
        return instance;
    }

    @Override
    public Set<Location> availableLocations() {
        return AVAILABLE_LOCATIONS;
    }

    @Override
    public void setEnabledIn(Location location, boolean enabled) {
        if (!this.availableLocations().contains((Object)location)) {
            return;
        }
        SkyblockerConfigManager.get().slayers.enableHud = enabled;
    }

    @Override
    public boolean isEnabledIn(Location location) {
        return this.availableLocations().contains((Object)location) && SkyblockerConfigManager.get().slayers.enableHud;
    }

    @Override
    public boolean shouldRender(Location location) {
        return super.shouldRender(location) && SlayerManager.isInSlayer() && !SlayerManager.getSlayerType().isUnknown() && !SlayerManager.getSlayerTier().isUnknown();
    }

    @Override
    public void updateContent() {
        if (class_310.method_1551().field_1755 instanceof WidgetsConfigurationScreen) {
            SlayerType type = SlayerType.REVENANT;
            SlayerTier tier = SlayerTier.V;
            this.addSimpleIcoText(type.icon, "", tier.color, type.bossName + " " + String.valueOf((Object)tier));
            this.addSimpleIcoText(Ico.EXPERIENCE_BOTTLE, "XP: ", class_124.field_1076, "100,000/400,000");
            this.addComponent(new IcoTextComponent(Ico.NETHER_STAR, (class_2561)class_2561.method_43469((String)"skyblocker.slayer.hud.levelUpIn", (Object[])new Object[]{class_2561.method_43470((String)"200").method_27692(class_124.field_1076)})));
            return;
        }
        if (this.client.field_1724 == null || SlayerManager.getSlayerQuest() == null) {
            return;
        }
        SlayerType type = SlayerManager.getSlayerType();
        SlayerTier tier = SlayerManager.getSlayerTier();
        int level = SlayerManager.getSlayerQuest().level;
        int bossesNeeded = SlayerManager.getSlayerQuest().bossesNeeded;
        if (type == null || tier == null) {
            return;
        }
        this.addSimpleIcoText(type.icon, "", tier.color, type.bossName + " " + String.valueOf((Object)tier));
        if (level > 0) {
            if (level == type.maxLevel) {
                this.addComponent(new IcoTextComponent(Ico.EXPERIENCE_BOTTLE, (class_2561)class_2561.method_43470((String)"XP: ").method_10852((class_2561)class_2561.method_43471((String)"skyblocker.slayer.hud.levelMaxed").method_27692(class_124.field_1060))));
            } else {
                int nextMilestone = type.levelMilestones[level];
                int currentXP = nextMilestone - SlayerManager.getSlayerQuest().xpRemaining;
                this.addSimpleIcoText(Ico.EXPERIENCE_BOTTLE, "XP: ", class_124.field_1076, Formatters.INTEGER_NUMBERS.format(currentXP) + "/" + Formatters.INTEGER_NUMBERS.format(nextMilestone));
            }
        }
        if (bossesNeeded > 0) {
            this.addComponent(new IcoTextComponent(Ico.NETHER_STAR, (class_2561)class_2561.method_43469((String)"skyblocker.slayer.hud.levelUpIn", (Object[])new Object[]{class_2561.method_43470((String)Formatters.INTEGER_NUMBERS.format(bossesNeeded)).method_27692(class_124.field_1076)})));
        }
    }

    @Override
    public class_2561 getDisplayName() {
        return class_2561.method_43470((String)"Slayer Hud");
    }
}

