/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.special;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.utils.Utils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DungeonsSpecialEffects {
    private static final Logger LOGGER = LoggerFactory.getLogger(DungeonsSpecialEffects.class);
    private static final class_310 CLIENT = class_310.method_1551();
    private static final Pattern DROP_PATTERN = Pattern.compile("(?:\\[[A-Z+]+] )?(?<player>[A-Za-z0-9_]+) unlocked (?<item>.+)!");

    @Init
    public static void init() {
        ClientReceiveMessageEvents.ALLOW_GAME.register(DungeonsSpecialEffects::displayRareDropEffect);
    }

    private static boolean displayRareDropEffect(class_2561 message, boolean overlay) {
        if (Utils.isOnSkyblock() && SkyblockerConfigManager.get().general.specialEffects.rareDungeonDropEffects && !overlay) {
            try {
                class_1799 stack;
                String stringForm = message.getString();
                Matcher matcher = DROP_PATTERN.matcher(stringForm);
                if (matcher.matches() && matcher.group("player").equals(CLIENT.method_1548().method_1676()) && (stack = DungeonsSpecialEffects.getStackFromName(matcher.group("item"))) != null && !stack.method_7960()) {
                    DungeonsSpecialEffects.CLIENT.field_1713.method_3051((class_1297)DungeonsSpecialEffects.CLIENT.field_1724, (class_2394)class_2398.field_11214, 30);
                    DungeonsSpecialEffects.CLIENT.field_1773.method_3189(stack);
                }
            }
            catch (Exception e) {
                LOGGER.error("[Skyblocker Special Effects] An unexpected exception was encountered: ", (Throwable)e);
            }
        }
        return true;
    }

    private static class_1799 getStackFromName(String itemName) {
        String itemId = switch (itemName) {
            case "Necron Dye" -> "NECRON_DYE";
            case "Dark Claymore" -> "DARK_CLAYMORE";
            case "Necron's Handle", "Shiny Necron's Handle" -> "NECRON_HANDLE";
            case "Enchanted Book (Thunderlord VII)" -> "ENCHANTED_BOOK";
            case "Master Skull - Tier 5" -> "MASTER_SKULL_TIER_5";
            case "Shadow Warp", "Wither Shield", "Implosion" -> "IMPLOSION_SCROLL";
            case "Fifth Master Star" -> "FIFTH_MASTER_STAR";
            case "Giant's Sword" -> "GIANTS_SWORD";
            default -> "NONE";
        };
        return ItemRepository.getItemStack(itemId);
    }
}

