/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.tabhud.screenbuilder;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.tabhud.screenbuilder.WidgetManager;
import de.hysky.skyblocker.skyblock.tabhud.screenbuilder.pipeline.CenteredWidgetPositioner;
import de.hysky.skyblocker.skyblock.tabhud.screenbuilder.pipeline.PositionRule;
import de.hysky.skyblocker.skyblock.tabhud.screenbuilder.pipeline.TopAlignedWidgetPositioner;
import de.hysky.skyblocker.skyblock.tabhud.screenbuilder.pipeline.WidgetPositioner;
import de.hysky.skyblocker.skyblock.tabhud.util.PlayerListManager;
import de.hysky.skyblocker.skyblock.tabhud.widget.HudWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.TabHudWidget;
import de.hysky.skyblocker.utils.Location;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;

public class ScreenBuilder {
    private static boolean positionsNeedsUpdating = true;
    private final Map<String, PositionRule> positioning = new Object2ObjectOpenHashMap();
    private Map<String, PositionRule> positioningBackup = null;
    private final Location location;
    private List<HudWidget> hudScreen = new ArrayList<HudWidget>();
    private List<HudWidget> mainTabScreen = new ArrayList<HudWidget>();
    private List<HudWidget> secondaryTabScreen = new ArrayList<HudWidget>();

    public ScreenBuilder(Location location) {
        this.location = location;
    }

    @Nullable
    public PositionRule getPositionRule(String widgetInternalId) {
        return this.positioning.get(widgetInternalId);
    }

    public void forEachPositionRuleEntry(BiConsumer<String, PositionRule> action) {
        this.positioning.forEach(action);
    }

    public PositionRule getPositionRuleOrDefault(String widgetInternalId) {
        PositionRule positionRule = this.getPositionRule(widgetInternalId);
        return positionRule == null ? PositionRule.DEFAULT : positionRule;
    }

    public void setPositionRule(String widgetInternalId, @Nullable PositionRule newPositionRule) {
        if (newPositionRule == null) {
            this.positioning.remove(widgetInternalId);
        } else {
            this.positioning.put(widgetInternalId, newPositionRule);
        }
    }

    public void backupPositioning() {
        this.positioningBackup = Map.copyOf(this.positioning);
    }

    public void restorePositioningFromBackup() {
        if (this.positioningBackup == null) {
            return;
        }
        this.positioning.clear();
        this.positioning.putAll(this.positioningBackup);
    }

    public static void markDirty() {
        positionsNeedsUpdating = true;
    }

    public boolean updateWidgetLists(boolean config) {
        int n;
        WidgetManager.ScreenLayer screenLayer;
        PositionRule rule;
        ArrayList<HudWidget> hudNew = new ArrayList<HudWidget>();
        ArrayList<HudWidget> mainTabNew = new ArrayList<HudWidget>();
        ArrayList<HudWidget> secondaryTabNew = new ArrayList<HudWidget>();
        for (HudWidget hudWidget : WidgetManager.widgetInstances.values()) {
            hudWidget.setVisible(false);
            if (!(config ? hudWidget.isEnabledIn(this.location) : hudWidget.shouldRender(this.location))) continue;
            rule = this.getPositionRule(hudWidget.getInternalID());
            if (rule == null) {
                hudNew.add(hudWidget);
            } else {
                screenLayer = rule.screenLayer();
                n = 0;
                switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"MAIN_TAB", "SECONDARY_TAB"}, (WidgetManager.ScreenLayer)screenLayer, n)) {
                    case 0: {
                        mainTabNew.add(hudWidget);
                        break;
                    }
                    case 1: {
                        secondaryTabNew.add(hudWidget);
                        break;
                    }
                    default: {
                        hudNew.add(hudWidget);
                    }
                }
            }
            hudWidget.setVisible(true);
            hudWidget.setPositioned(false);
        }
        block9: for (TabHudWidget tabHudWidget : PlayerListManager.tabWidgetsToShow) {
            rule = this.getPositionRule(tabHudWidget.getInternalID());
            tabHudWidget.setVisible(true);
            if (rule == null) {
                mainTabNew.add(tabHudWidget);
                continue;
            }
            tabHudWidget.setPositioned(false);
            screenLayer = rule.screenLayer();
            n = 0;
            switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"HUD", "SECONDARY_TAB"}, (WidgetManager.ScreenLayer)screenLayer, n)) {
                case 0: {
                    hudNew.add(tabHudWidget);
                    continue block9;
                }
                case 1: {
                    secondaryTabNew.add(tabHudWidget);
                    continue block9;
                }
            }
            mainTabNew.add(tabHudWidget);
        }
        if (this.hudScreen.equals(hudNew) && this.mainTabScreen.equals(mainTabNew) && this.secondaryTabScreen.equals(secondaryTabNew)) {
            return false;
        }
        this.hudScreen = hudNew;
        this.mainTabScreen = mainTabNew;
        this.secondaryTabScreen = secondaryTabNew;
        return true;
    }

    public void updateWidgets(WidgetManager.ScreenLayer screenLayer) {
        for (HudWidget widget : this.getHudWidgets(screenLayer)) {
            if (!widget.shouldUpdateBeforeRendering()) continue;
            widget.update();
        }
    }

    public void positionWidgets(int screenW, int screenH) {
        WidgetPositioner newPositioner = SkyblockerConfigManager.get().uiAndVisuals.tabHud.defaultPositioning.getNewPositioner(screenW, screenH);
        for (HudWidget widget : this.mainTabScreen) {
            if (this.getPositionRule(widget.getInternalID()) != null) {
                widget.setPositioned(false);
                continue;
            }
            newPositioner.positionWidget(widget);
            widget.setPositioned(true);
        }
        newPositioner.finalizePositioning();
        for (HudWidget widget : this.mainTabScreen) {
            if (widget.isPositioned()) continue;
            WidgetPositioner.applyRuleToWidget(widget, screenW, screenH, this::getPositionRule);
        }
        for (HudWidget widget : this.hudScreen) {
            if (widget.isPositioned()) continue;
            WidgetPositioner.applyRuleToWidget(widget, screenW, screenH, this::getPositionRule);
        }
        for (HudWidget widget : this.secondaryTabScreen) {
            if (widget.isPositioned()) continue;
            WidgetPositioner.applyRuleToWidget(widget, screenW, screenH, this::getPositionRule);
        }
    }

    public void renderWidgets(class_332 context, WidgetManager.ScreenLayer screenLayer) {
        List<HudWidget> widgetsToRender = this.getHudWidgets(screenLayer);
        for (HudWidget widget : widgetsToRender) {
            widget.render(context);
        }
    }

    public List<HudWidget> getHudWidgets(WidgetManager.ScreenLayer screenLayer) {
        WidgetManager.ScreenLayer screenLayer2 = screenLayer;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"MAIN_TAB", "SECONDARY_TAB", "HUD"}, (WidgetManager.ScreenLayer)screenLayer2, n)) {
            case 0 -> this.mainTabScreen;
            case 1 -> this.secondaryTabScreen;
            case 2 -> this.hudScreen;
            default -> List.of();
        };
    }

    public void run(class_332 context, int screenW, int screenH, WidgetManager.ScreenLayer screenLayer) {
        boolean widgetListsChanged = this.updateWidgetLists(false);
        this.updateWidgets(screenLayer);
        if (widgetListsChanged || positionsNeedsUpdating) {
            positionsNeedsUpdating = false;
            this.positionWidgets(screenW, screenH);
        }
        this.renderWidgets(context, screenLayer);
    }

    public static enum DefaultPositioner {
        TOP(TopAlignedWidgetPositioner::new),
        CENTERED(CenteredWidgetPositioner::new);

        private final BiFunction<Integer, Integer, WidgetPositioner> function;

        private DefaultPositioner(BiFunction<Integer, Integer, WidgetPositioner> widgetPositionerSupplier) {
            this.function = widgetPositionerSupplier;
        }

        public WidgetPositioner getNewPositioner(int screenWidth, int screenHeight) {
            return this.function.apply(screenWidth, screenHeight);
        }
    }
}

