/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.tabhud.util;

import com.mojang.authlib.GameProfile;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.mixins.accessors.PlayerListHudAccessor;
import de.hysky.skyblocker.skyblock.tabhud.config.WidgetsConfigurationScreen;
import de.hysky.skyblocker.skyblock.tabhud.screenbuilder.WidgetManager;
import de.hysky.skyblocker.skyblock.tabhud.widget.TabHudWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.PlainTextComponent;
import de.hysky.skyblocker.utils.Utils;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.IntObjectPair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectObjectMutablePair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_640;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerListManager {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Skyblocker Regex");
    private static final Pattern PLAYERS_COLUMN_PATTERN = Pattern.compile("\\s*(Players \\(\\d+\\)|Island|Coop \\(\\d+\\))\\s*");
    private static final Pattern INFO_COLUMN_PATTERN = Pattern.compile("\\s*Info\\s*");
    private static List<class_640> playerList = new ArrayList<class_640>();
    private static List<String> playerStringList = new ArrayList<String>();
    @Nullable
    private static String footer;
    public static final Map<String, TabHudWidget> tabWidgetInstances;
    public static final List<TabHudWidget> tabWidgetsToShow;

    private static void reset() {
        if (!tabWidgetsToShow.isEmpty()) {
            tabWidgetsToShow.clear();
        }
    }

    public static void updateList() {
        WidgetsConfigurationScreen widgetsConfigurationScreen;
        if (!Utils.isOnSkyblock()) {
            PlayerListManager.reset();
            return;
        }
        class_634 networkHandler = class_310.method_1551().method_1562();
        if (networkHandler != null) {
            playerList = networkHandler.method_2880().stream().sorted(PlayerListHudAccessor.getOrdering()).toList();
            playerStringList = playerList.stream().map(class_640::method_2971).filter(Objects::nonNull).map(class_2561::getString).map(String::strip).toList();
        }
        if (!SkyblockerConfigManager.get().uiAndVisuals.tabHud.tabHudEnabled) {
            PlayerListManager.reset();
            return;
        }
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof WidgetsConfigurationScreen && (widgetsConfigurationScreen = (WidgetsConfigurationScreen)class_4372).isPreviewVisible()) {
            return;
        }
        if (Utils.isInDungeons()) {
            PlayerListManager.updateDungeons(null);
        } else {
            PlayerListManager.updateWidgetsFrom(playerList);
        }
    }

    public static void updateDungeons(List<class_2561> lines) {
        int i;
        if (lines != null) {
            playerList = new ArrayList<class_640>();
            for (i = 0; i < lines.size(); ++i) {
                playerList.add(new class_640(new GameProfile(UUID.randomUUID(), String.valueOf(i)), false));
                playerList.getLast().method_2962(lines.get(i));
            }
        }
        tabWidgetsToShow.clear();
        tabWidgetsToShow.add(PlayerListManager.getTabHudWidget("Dungeon Buffs", List.of()));
        tabWidgetsToShow.add(PlayerListManager.getTabHudWidget("Dungeon Deaths", List.of()));
        tabWidgetsToShow.add(PlayerListManager.getTabHudWidget("Dungeon Downed", List.of()));
        tabWidgetsToShow.add(PlayerListManager.getTabHudWidget("Dungeon Puzzles", List.of()));
        tabWidgetsToShow.add(PlayerListManager.getTabHudWidget("Dungeon Discoveries", List.of()));
        tabWidgetsToShow.add(PlayerListManager.getTabHudWidget("Dungeon Info", List.of()));
        for (i = 1; i < 6; ++i) {
            tabWidgetsToShow.add(PlayerListManager.getTabHudWidget("Dungeon Player " + i, List.of()));
        }
    }

    public static void updateWidgetsFrom(List<class_640> lines) {
        Predicate<String> playersColumnPredicate = PLAYERS_COLUMN_PATTERN.asMatchPredicate();
        Predicate<String> infoColumnPredicate = INFO_COLUMN_PATTERN.asMatchPredicate();
        tabWidgetsToShow.clear();
        boolean doingPlayers = false;
        boolean playersDone = false;
        IntObjectPair hypixelWidgetName = IntObjectPair.of((int)0xFFFF00, (Object)"");
        ArrayList<class_2561> contents = new ArrayList<class_2561>();
        ArrayList<class_640> playerListEntries = new ArrayList<class_640>();
        for (class_640 playerListEntry : lines) {
            String string;
            class_2561 displayName = playerListEntry.method_2971();
            if (displayName == null || (string = displayName.getString()).isBlank()) continue;
            if (!playersDone) {
                if (playersColumnPredicate.test(string)) {
                    if (doingPlayers) continue;
                    doingPlayers = true;
                    hypixelWidgetName = IntObjectPair.of((int)class_124.field_1075.method_532(), (Object)"Players");
                    continue;
                }
                if (infoColumnPredicate.test(string)) {
                    playersDone = true;
                    if (!contents.isEmpty()) {
                        tabWidgetsToShow.add(PlayerListManager.getTabHudWidget((IntObjectPair<String>)hypixelWidgetName, contents, playerListEntries));
                    }
                    contents.clear();
                    playerListEntries.clear();
                    continue;
                }
            } else {
                if (infoColumnPredicate.test(string)) continue;
                if (!(string.startsWith(" ") || !string.contains(":") || ((String)hypixelWidgetName.right()).startsWith("Mining Event") && string.toLowerCase().startsWith("ends in"))) {
                    if (!contents.isEmpty()) {
                        tabWidgetsToShow.add(PlayerListManager.getTabHudWidget((IntObjectPair<String>)hypixelWidgetName, contents, playerListEntries));
                    }
                    contents.clear();
                    playerListEntries.clear();
                    Pair<IntObjectPair<String>, ? extends class_2561> nameAndInfo = PlayerListManager.getNameAndInfo(displayName);
                    hypixelWidgetName = (IntObjectPair)nameAndInfo.left();
                    if (((class_2561)nameAndInfo.right()).getString().isBlank()) continue;
                    contents.add(PlayerListManager.trim((class_2561)nameAndInfo.right()));
                    playerListEntries.add(playerListEntry);
                    continue;
                }
            }
            contents.add(PlayerListManager.trim(displayName));
            playerListEntries.add(playerListEntry);
        }
        if (!contents.isEmpty()) {
            tabWidgetsToShow.add(PlayerListManager.getTabHudWidget((IntObjectPair<String>)hypixelWidgetName, contents, playerListEntries));
        }
        if (!tabWidgetsToShow.contains(tabWidgetInstances.get("Active Effects")) && SkyblockerConfigManager.get().uiAndVisuals.tabHud.effectsFromFooter) {
            tabWidgetsToShow.add(PlayerListManager.getTabHudWidget("Active Effects", List.of()));
        }
    }

    private static class_2561 trim(class_2561 text) {
        ArrayList<class_5250> trimmedParts = new ArrayList<class_5250>();
        AtomicBoolean leadingSpaceFound = new AtomicBoolean(false);
        text.method_27658((style, asString) -> {
            String trimmed = asString;
            if (!leadingSpaceFound.get()) {
                if (!(trimmed = trimmed.stripLeading()).isBlank()) {
                    leadingSpaceFound.set(true);
                } else {
                    return Optional.empty();
                }
            }
            trimmedParts.add(class_2561.method_43470((String)trimmed).method_10862(style));
            return Optional.empty();
        }, class_2583.field_24360);
        for (int i = 0; i < trimmedParts.size(); ++i) {
            class_2561 last = (class_2561)trimmedParts.removeLast();
            String trimmed = last.getString().stripTrailing();
            if (trimmed.isBlank()) continue;
            trimmedParts.add(class_2561.method_43470((String)trimmed).method_10862(last.method_10866()));
            break;
        }
        class_5250 out = class_2561.method_43473();
        trimmedParts.forEach(arg_0 -> ((class_5250)out).method_10852(arg_0));
        return out;
    }

    private static TabHudWidget getTabHudWidget(IntObjectPair<String> hypixelWidgetName, List<class_2561> lines, @Nullable List<class_640> playerListEntries) {
        TabHudWidget tabHudWidget;
        if (tabWidgetInstances.containsKey(hypixelWidgetName.right())) {
            tabHudWidget = tabWidgetInstances.get(hypixelWidgetName.right());
        } else {
            tabHudWidget = new DefaultTabHudWidget((String)hypixelWidgetName.right(), class_2561.method_43470((String)((String)hypixelWidgetName.right())).method_27692(class_124.field_1067), hypixelWidgetName.firstInt());
            WidgetManager.addWidgetInstance(tabHudWidget);
        }
        tabHudWidget.updateFromTab(lines, playerListEntries);
        tabHudWidget.update();
        return tabHudWidget;
    }

    private static TabHudWidget getTabHudWidget(String hypixelWidgetName, List<class_2561> lines) {
        return PlayerListManager.getTabHudWidget((IntObjectPair<String>)IntObjectPair.of((int)-65536, (Object)hypixelWidgetName), lines, null);
    }

    private static Pair<IntObjectPair<String>, ? extends class_2561> getNameAndInfo(class_2561 text) {
        ObjectObjectMutablePair toReturn = new ObjectObjectMutablePair((Object)"", (Object)class_2561.method_43473());
        AtomicBoolean inInfo = new AtomicBoolean(false);
        AtomicInteger colorOutput = new AtomicInteger(0xFFFF00);
        text.method_27658((style, asString) -> {
            if (inInfo.get()) {
                ((class_5250)toReturn.right()).method_10852((class_2561)class_2561.method_43470((String)asString).method_27696(style));
            } else if (asString.contains(":")) {
                inInfo.set(true);
                String[] split = asString.split(":", 2);
                toReturn.left((Object)((String)toReturn.left() + split[0]));
                ((class_5250)toReturn.right()).method_10852((class_2561)class_2561.method_43470((String)split[1]).method_27696(style));
                if (style.method_10973() != null) {
                    colorOutput.set(style.method_10973().method_27716());
                }
            } else {
                toReturn.left((Object)((String)toReturn.left() + asString));
            }
            return Optional.empty();
        }, class_2583.field_24360);
        return Pair.of((Object)IntObjectPair.of((int)colorOutput.get(), (Object)((String)toReturn.left())), (Object)((class_5250)toReturn.right()));
    }

    public static List<class_640> getPlayerList() {
        return playerList;
    }

    public static List<String> getPlayerStringList() {
        return playerStringList;
    }

    public static void updateFooter(class_2561 f) {
        if (f == null) {
            footer = null;
        } else {
            footer = f.getString();
            if (footer.isEmpty()) {
                footer = null;
            }
        }
    }

    @Nullable
    public static String getFooter() {
        return footer;
    }

    public static Matcher regexAt(int idx, Pattern p) {
        String str = PlayerListManager.strAt(idx);
        if (str == null) {
            return null;
        }
        Matcher m = p.matcher(str);
        if (!m.matches()) {
            LOGGER.error("no match: \"{}\" against \"{}\"", (Object)str, (Object)p);
            return null;
        }
        return m;
    }

    public static String strAt(int idx) {
        if (playerList == null) {
            return null;
        }
        if (playerList.size() <= idx) {
            return null;
        }
        class_2561 txt = playerList.get(idx).method_2971();
        if (txt == null) {
            return null;
        }
        String str = txt.getString().trim();
        if (str.isEmpty()) {
            return null;
        }
        return str;
    }

    public static class_2561 textAt(int idx) {
        if (playerList == null) {
            return null;
        }
        if (playerList.size() <= idx) {
            return null;
        }
        class_2561 txt = playerList.get(idx).method_2971();
        if (txt == null) {
            return null;
        }
        class_5250 newText = class_2561.method_43473();
        int size = txt.method_10855().size();
        for (int i = 0; i < size; ++i) {
            class_2561 current = (class_2561)txt.method_10855().get(i);
            String textToAppend = current.getString();
            if (i == 0) {
                textToAppend = textToAppend.stripLeading();
            }
            if (i == size - 1) {
                textToAppend = textToAppend.stripTrailing();
            }
            newText.method_10852((class_2561)class_2561.method_43470((String)textToAppend).method_10862(current.method_10866()));
        }
        if (newText.getString().isEmpty()) {
            return null;
        }
        return newText;
    }

    public static class_640 getRaw(int idx) {
        return playerList.get(idx);
    }

    public static int getSize() {
        return playerList.size();
    }

    static {
        tabWidgetInstances = new Object2ObjectOpenHashMap();
        tabWidgetsToShow = new ObjectArrayList(5);
    }

    private static final class DefaultTabHudWidget
    extends TabHudWidget {
        private DefaultTabHudWidget(String hypixelWidgetName, class_5250 title, int color) {
            super(hypixelWidgetName, title, color);
        }

        @Override
        protected void updateContent(List<class_2561> lines) {
            lines.forEach(text -> this.addComponent(new PlainTextComponent((class_2561)text)));
        }
    }
}

