/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.tabhud.widget;

import com.mojang.logging.LogUtils;
import de.hysky.skyblocker.annotations.RegisterWidget;
import de.hysky.skyblocker.skyblock.tabhud.util.Ico;
import de.hysky.skyblocker.skyblock.tabhud.widget.TabHudWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.Component;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.Components;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.IcoTextComponent;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.slf4j.Logger;

@RegisterWidget
public class CommsWidget
extends TabHudWidget {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String ID = "commissions";
    private static final class_5250 TITLE = class_2561.method_43470((String)"Commissions").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067});
    public static final Pattern COMM_PATTERN = Pattern.compile("(?<name>.*): (?<progress>.*)%?");

    public CommsWidget() {
        super("Commissions", TITLE, class_124.field_1062.method_532());
    }

    @Override
    public void updateContent(List<class_2561> lines) {
        if (lines.isEmpty()) {
            this.addComponent(new IcoTextComponent());
            return;
        }
        for (class_2561 line : lines) {
            Component component;
            Matcher m = COMM_PATTERN.matcher(line.getString());
            if (!m.matches()) continue;
            String name = m.group("name");
            String progress = m.group("progress");
            if (progress.equals("DONE")) {
                component = Components.progressComponent(Ico.BOOK, class_2561.method_30163((String)name), class_2561.method_30163((String)progress), 100.0f);
            } else {
                float percent;
                try {
                    percent = Float.parseFloat(progress.substring(0, progress.length() - 1));
                }
                catch (NumberFormatException e) {
                    LOGGER.error("[Skyblocker Comms Widget] Failed to parse number.", (Throwable)e);
                    percent = 0.0f;
                }
                component = Components.progressComponent(Ico.BOOK, class_2561.method_30163((String)name), percent);
            }
            this.addComponent(component);
        }
    }
}

