/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.tabhud.widget;

import com.demonwav.mcdev.annotations.Translatable;
import com.mojang.logging.LogUtils;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.tabhud.screenbuilder.ScreenBuilder;
import de.hysky.skyblocker.skyblock.tabhud.util.PlayerListManager;
import de.hysky.skyblocker.skyblock.tabhud.widget.HudWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.Component;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.Components;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.IcoTextComponent;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.PlainTextComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.slf4j.Logger;

public abstract class ComponentBasedWidget
extends HudWidget {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final class_327 txtRend = class_310.method_1551().field_1772;
    private String lastError = null;
    private static final List<Component> ERROR_COMPONENTS = List.of(new PlainTextComponent((class_2561)class_2561.method_43470((String)"An error occurred! Please check logs.").method_54663(-65536)));
    private final ArrayList<Component> components = new ArrayList();
    private int prevW = 0;
    private int prevH = 0;
    public static final int BORDER_SZE_N;
    public static final int BORDER_SZE_S = 4;
    public static final int BORDER_SZE_W = 4;
    public static final int BORDER_SZE_E = 4;
    public static final int DEFAULT_COL_BG_BOX = -1072952308;
    public static final int MINIMAL_COL_BG_BOX = 0x64000000;
    private final int color;
    private final class_2561 title;

    public ComponentBasedWidget(class_5250 title, Integer colorValue, String internalID) {
        super(internalID);
        this.title = title;
        this.color = 0xFF000000 | colorValue;
    }

    public void addComponent(Component c) {
        c.setParent(this);
        this.components.add(c);
    }

    @Override
    public final void update() {
        this.components.clear();
        try {
            this.updateContent();
        }
        catch (Exception e) {
            if (e.getMessage() == null || !e.getMessage().equals(this.lastError)) {
                this.lastError = e.getMessage();
                LOGGER.error("Failed to update contents of {}", (Object)this, (Object)e);
            }
            this.components.clear();
            this.components.addAll(ERROR_COMPONENTS);
        }
        this.pack();
    }

    public abstract void updateContent();

    public final void addSimpleIcoText(class_1799 ico, String string, class_124 fmt, int idx) {
        class_2561 txt = ComponentBasedWidget.simpleEntryText(idx, string, fmt);
        this.addComponent(Components.iconTextComponent(ico, txt));
    }

    public final void addSimpleIcoText(class_1799 ico, String string, class_124 fmt, String content) {
        class_2561 txt = ComponentBasedWidget.simpleEntryText(content, string, fmt);
        this.addComponent(Components.iconTextComponent(ico, txt));
    }

    public final void addSimpleIconTranslatableText(class_1799 icon, @Translatable String translationKey, class_124 formatting, String content) {
        class_2561 text = ComponentBasedWidget.simpleEntryTranslatableText(translationKey, content, formatting);
        this.addComponent(new IcoTextComponent(icon, text));
    }

    public final void addSimpleIconTranslatableText(class_1799 icon, @Translatable String translationKey, class_124 formatting, class_2561 content) {
        class_2561 text = ComponentBasedWidget.simpleEntryTranslatableText(translationKey, content, formatting);
        this.addComponent(new IcoTextComponent(icon, text));
    }

    @Override
    public final void renderWidget(class_332 context, int mouseX, int mouseY, float delta) {
        if (SkyblockerConfigManager.get().uiAndVisuals.tabHud.enableHudBackground) {
            class_315 options = class_310.method_1551().field_1690;
            int textBackgroundColor = options.method_19344(SkyblockerConfigManager.get().uiAndVisuals.tabHud.style.isMinimal() ? 0x64000000 : -1072952308);
            context.method_25294(this.x + 1, this.y, this.x + this.w - 1, this.y + this.h, textBackgroundColor);
            context.method_25294(this.x, this.y + 1, this.x + 1, this.y + this.h - 1, textBackgroundColor);
            context.method_25294(this.x + this.w - 1, this.y + 1, this.x + this.w, this.y + this.h - 1, textBackgroundColor);
        }
        Objects.requireNonNull(txtRend);
        int strHeightHalf = 9 / 2;
        int strAreaWidth = txtRend.method_27525((class_5348)this.title) + 4;
        context.method_51439(txtRend, this.title, this.x + 8, this.y + 2, this.color, false);
        if (!SkyblockerConfigManager.get().uiAndVisuals.tabHud.style.isMinimal()) {
            this.drawHLine(context, this.x + 2, this.y + 1 + strHeightHalf, 4);
            this.drawHLine(context, this.x + 2 + strAreaWidth + 4, this.y + 1 + strHeightHalf, this.w - 4 - 4 - strAreaWidth);
            this.drawHLine(context, this.x + 2, this.y + this.h - 2, this.w - 4);
            this.drawVLine(context, this.x + 1, this.y + 2 + strHeightHalf, this.h - 4 - strHeightHalf);
            this.drawVLine(context, this.x + this.w - 2, this.y + 2 + strHeightHalf, this.h - 4 - strHeightHalf);
        }
        int yOffs = this.y + BORDER_SZE_N;
        for (Component c : this.components) {
            c.render(context, this.x + 4, yOffs);
            yOffs += c.getHeight() + 4;
        }
    }

    private void pack() {
        this.h = 0;
        this.w = 0;
        for (Component c : this.components) {
            this.h += c.getHeight() + 4;
            this.w = Math.max(this.w, c.getWidth() + 2);
        }
        this.h -= 2;
        this.h += BORDER_SZE_N + 4 - 2;
        this.w += 8;
        this.w = Math.max(this.w, 8 + txtRend.method_27525((class_5348)this.title) + 4 + 4 + 1);
        if (this.h != this.prevH || this.w != this.prevW) {
            ScreenBuilder.markDirty();
        }
        this.prevW = this.w;
        this.prevH = this.h;
    }

    private void drawHLine(class_332 context, int xpos, int ypos, int width) {
        context.method_25294(xpos, ypos, xpos + width, ypos + 1, this.color);
    }

    private void drawVLine(class_332 context, int xpos, int ypos, int height) {
        context.method_25294(xpos, ypos, xpos + 1, ypos + height, this.color);
    }

    public static class_2561 simpleEntryText(int idx, String entryName, class_124 contentFmt) {
        String src = PlayerListManager.strAt(idx);
        if (src == null) {
            return null;
        }
        int cidx = src.indexOf(58);
        if (cidx == -1) {
            return null;
        }
        src = src.substring(src.indexOf(58) + 1);
        return ComponentBasedWidget.simpleEntryText(src, entryName, contentFmt);
    }

    public static class_2561 simpleEntryText(String entryContent, String entryName, class_124 contentFmt) {
        return class_2561.method_43470((String)entryName).method_10852((class_2561)class_2561.method_43470((String)entryContent).method_27692(contentFmt));
    }

    public static class_2561 simpleEntryTranslatableText(String translationKey, String content, class_124 contentFormatting) {
        return class_2561.method_43469((String)translationKey, (Object[])new Object[]{class_2561.method_43470((String)content).method_27692(contentFormatting)});
    }

    public static class_2561 simpleEntryTranslatableText(String translationKey, class_2561 content, class_124 contentFormatting) {
        return class_2561.method_43469((String)translationKey, (Object[])new Object[]{content.method_27661().method_27692(contentFormatting)});
    }

    public static class_2561 plainEntryText(int idx) {
        String str = PlayerListManager.strAt(idx);
        if (str == null) {
            return null;
        }
        return class_2561.method_30163((String)str);
    }

    static {
        Objects.requireNonNull(txtRend);
        BORDER_SZE_N = 9 + 4;
    }
}

