/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.tabhud.widget;

import de.hysky.skyblocker.annotations.RegisterWidget;
import de.hysky.skyblocker.skyblock.tabhud.util.Ico;
import de.hysky.skyblocker.skyblock.tabhud.util.PlayerListManager;
import de.hysky.skyblocker.skyblock.tabhud.widget.TabHudWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.IcoFatTextComponent;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.IcoTextComponent;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.PlainTextComponent;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

@RegisterWidget
public class EffectWidget
extends TabHudWidget {
    private static final class_5250 TITLE = class_2561.method_43470((String)"Active Effects").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067});
    private static final Pattern COOKIE_PATTERN = Pattern.compile(".*\\nCookie Buff\\n(?<buff>.*)\\n");

    public EffectWidget() {
        super("Active Effects", TITLE, class_124.field_1064.method_532());
    }

    @Override
    public void updateContent(List<class_2561> lines) {
        if (lines.isEmpty()) {
            this.fetchFromFooter();
        } else {
            this.fetchFromWidget(lines);
        }
    }

    private void fetchFromWidget(List<class_2561> lines) {
        String string = lines.getFirst().getString().replaceAll("[()]", "");
        this.addComponent(new PlainTextComponent((class_2561)class_2561.method_43470((String)string).method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}).method_10852((class_2561)class_2561.method_43470((String)" effect(s) active").method_27692(class_124.field_1068))));
        for (int i = 1; i < lines.size(); ++i) {
            this.addComponent(new PlainTextComponent(lines.get(i)));
        }
    }

    private void fetchFromFooter() {
        String[] lines;
        String footertext = PlayerListManager.getFooter();
        if (footertext == null || !footertext.contains("Active Effects")) {
            this.addComponent(new IcoTextComponent());
            return;
        }
        Matcher m = COOKIE_PATTERN.matcher(footertext);
        if (m.find() && m.group("buff") != null) {
            String buff = m.group("buff");
            if (buff.startsWith("Not")) {
                this.addComponent(new IcoTextComponent(Ico.COOKIE, class_2561.method_30163((String)"Cookie: not active")));
            } else {
                class_5250 cookie = class_2561.method_43470((String)"Cookie: ").method_27693(buff);
                this.addComponent(new IcoTextComponent(Ico.COOKIE, (class_2561)cookie));
            }
        }
        if ((lines = footertext.split("Active Effects")[1].split("\n")).length < 2) {
            this.addComponent(new IcoTextComponent());
            return;
        }
        if (lines[1].startsWith("No")) {
            class_5250 txt = class_2561.method_43470((String)"No effects active").method_27692(class_124.field_1080);
            this.addComponent(new IcoTextComponent(Ico.POTION, (class_2561)txt));
        } else if (lines[1].contains("God")) {
            String timeleft = lines[1].split("! ")[1];
            class_5250 godpot = class_2561.method_43470((String)"God potion!").method_27692(class_124.field_1061);
            class_5250 txttleft = class_2561.method_43470((String)timeleft).method_27692(class_124.field_1076);
            IcoFatTextComponent iftc = new IcoFatTextComponent(Ico.POTION, (class_2561)godpot, (class_2561)txttleft);
            this.addComponent(iftc);
        } else {
            String number = lines[1].substring("You have ".length());
            int idx = number.indexOf(32);
            if (idx == -1 || lines.length < 4) {
                this.addComponent(new IcoFatTextComponent());
                return;
            }
            number = number.substring(0, idx);
            class_5250 active = class_2561.method_43470((String)"Active Effects: ").method_10852((class_2561)class_2561.method_43470((String)number).method_27692(class_124.field_1054));
            IcoFatTextComponent iftc = new IcoFatTextComponent(Ico.POTION, (class_2561)active, (class_2561)class_2561.method_43470((String)lines[2]).method_27692(class_124.field_1075));
            this.addComponent(iftc);
        }
    }
}

