/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.tabhud.widget;

import de.hysky.skyblocker.annotations.RegisterWidget;
import de.hysky.skyblocker.skyblock.tabhud.util.Ico;
import de.hysky.skyblocker.skyblock.tabhud.widget.TabHudWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.IcoTextComponent;
import de.hysky.skyblocker.utils.Formatters;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.apache.commons.lang3.math.NumberUtils;

@RegisterWidget
public class PowderWidget
extends TabHudWidget {
    private static final class_5250 TITLE = class_2561.method_43470((String)"Powders").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067});
    private static final short UPDATE_INTERVAL = 2000;
    private static final Pattern MITHRIL_PATTERN = Pattern.compile("Mithril: ([\\d,]+)");
    private static final Pattern GEMSTONE_PATTERN = Pattern.compile("Gemstone: ([\\d,]+)");
    private static final Pattern GLACITE_PATTERN = Pattern.compile("Glacite: ([\\d,]+)");
    private int lastMithril = 0;
    private int lastGemstone = 0;
    private int lastGlacite = 0;
    private int lastMithrilDiff = 0;
    private int lastGemstoneDiff = 0;
    private int lastGlaciteDiff = 0;
    private byte updated = 0;
    private long lastUpdate = 0L;

    public PowderWidget() {
        super("Powders", TITLE, class_124.field_1062.method_532());
    }

    @Override
    public void updateContent(List<class_2561> lines) {
        Matcher matcher = Pattern.compile("").matcher("");
        long msAfterLastUpdate = class_156.method_658() - this.lastUpdate;
        for (class_2561 line : lines) {
            Objects.requireNonNull(matcher.reset(line.getString()));
            int n = 0;
            block6: while (true) {
                Matcher matcher2;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Matcher.class, Matcher.class, Matcher.class}, (Object)matcher2, n)) {
                    case 0: {
                        Matcher m = matcher2;
                        if (!m.usePattern(MITHRIL_PATTERN).matches()) {
                            n = 1;
                            continue block6;
                        }
                        int mithril = this.parseAmount(m);
                        if (mithril != this.lastMithril || msAfterLastUpdate > 2000L) {
                            this.lastMithrilDiff = mithril - this.lastMithril;
                            this.updated = (byte)(this.updated | 8);
                            this.addComponent(new IcoTextComponent(Ico.MITHRIL, this.getTextToDisplay(this.lastMithrilDiff, line, class_124.field_1077)));
                            this.lastMithril = mithril;
                        } else {
                            this.addComponent(new IcoTextComponent(Ico.MITHRIL, this.getTextToDisplay(this.lastMithrilDiff, line, class_124.field_1077)));
                        }
                        this.updated = (byte)(this.updated | 1);
                        break block6;
                    }
                    case 1: {
                        Matcher m = matcher2;
                        if (!m.usePattern(GEMSTONE_PATTERN).matches()) {
                            n = 2;
                            continue block6;
                        }
                        int gemstone = this.parseAmount(m);
                        if (gemstone != this.lastGemstone || msAfterLastUpdate > 2000L) {
                            this.lastGemstoneDiff = gemstone - this.lastGemstone;
                            this.updated = (byte)(this.updated | 8);
                            this.addComponent(new IcoTextComponent(Ico.AMETHYST_SHARD, this.getTextToDisplay(this.lastGemstoneDiff, line, class_124.field_1076)));
                            this.lastGemstone = gemstone;
                        } else {
                            this.addComponent(new IcoTextComponent(Ico.AMETHYST_SHARD, this.getTextToDisplay(this.lastGemstoneDiff, line, class_124.field_1076)));
                        }
                        this.updated = (byte)(this.updated | 2);
                        break block6;
                    }
                    case 2: {
                        Matcher m = matcher2;
                        if (!m.usePattern(GLACITE_PATTERN).matches()) {
                            n = 3;
                            continue block6;
                        }
                        int glacite = this.parseAmount(m);
                        if (glacite != this.lastGlacite || msAfterLastUpdate > 2000L) {
                            this.lastGlaciteDiff = glacite - this.lastGlacite;
                            this.updated = (byte)(this.updated | 8);
                            this.addComponent(new IcoTextComponent(Ico.BLUE_ICE, this.getTextToDisplay(this.lastGlaciteDiff, line, class_124.field_1075)));
                            this.lastGlacite = glacite;
                        } else {
                            this.addComponent(new IcoTextComponent(Ico.BLUE_ICE, this.getTextToDisplay(this.lastGlaciteDiff, line, class_124.field_1075)));
                        }
                        this.updated = (byte)(this.updated | 4);
                        break block6;
                    }
                }
                break;
            }
            if ((this.updated & 7) != 7) continue;
            break;
        }
        if ((this.updated & 8) == 8) {
            this.lastUpdate = class_156.method_658();
        }
        this.updated = 0;
    }

    private int parseAmount(Matcher matcher) {
        return NumberUtils.toInt((String)matcher.group(1).replace(",", ""));
    }

    private class_5250 getAppendix(int diff, class_124 formatting) {
        return class_2561.method_43470((String)(" (" + Formatters.DIFF_NUMBERS.format(diff) + ")")).method_27692(formatting);
    }

    private class_2561 getTextToDisplay(int diff, class_2561 line, class_124 formatting) {
        return diff != 0 ? line.method_27661().method_10852((class_2561)this.getAppendix(diff, formatting)) : line;
    }
}

