/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.waypoint;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import de.hysky.skyblocker.skyblock.waypoint.WaypointsListWidget;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.gui.DropdownWidget;
import de.hysky.skyblocker.utils.waypoint.NamedWaypoint;
import de.hysky.skyblocker.utils.waypoint.WaypointGroup;
import java.util.Arrays;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_437;

public abstract class AbstractWaypointsScreen<T extends class_437>
extends class_437 {
    protected final T parent;
    protected final Multimap<Location, WaypointGroup> waypoints;
    protected Location island;
    protected WaypointsListWidget waypointsListWidget;
    protected DropdownWidget<Location> islandWidget;

    public AbstractWaypointsScreen(class_2561 title, T parent) {
        this(title, parent, (Multimap<Location, WaypointGroup>)MultimapBuilder.enumKeys(Location.class).arrayListValues().build());
    }

    public AbstractWaypointsScreen(class_2561 title, T parent, Multimap<Location, WaypointGroup> waypoints) {
        this(title, parent, waypoints, Utils.getLocation());
    }

    public AbstractWaypointsScreen(class_2561 title, T parent, Multimap<Location, WaypointGroup> waypoints, Location island) {
        super(title);
        this.parent = parent;
        this.waypoints = waypoints;
        this.island = island;
    }

    protected void method_25426() {
        super.method_25426();
        this.waypointsListWidget = (WaypointsListWidget)this.method_37063((class_364)new WaypointsListWidget(this.field_22787, this, this.field_22789, this.field_22790 - 120, 32, 24));
    }

    protected final void lateInit() {
        this.islandWidget = (DropdownWidget)this.method_37063((class_364)new DropdownWidget<Location>(this.field_22787, this.field_22789 - 160, 8, 150, this.field_22790 - 8, Arrays.asList(Location.values()), this::islandChanged, this.island));
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.islandWidget.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        boolean mouseClicked = super.method_25402(mouseX, mouseY, button);
        this.updateButtons();
        return mouseClicked;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.islandWidget.method_25405(mouseX, mouseY) && this.islandWidget.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    protected void islandChanged(Location location) {
        this.island = location;
        this.waypointsListWidget.setIsland(this.island);
    }

    protected boolean isEnabled(NamedWaypoint waypoint) {
        return waypoint.isEnabled();
    }

    protected void enabledChanged(NamedWaypoint waypoint, boolean enabled) {
        waypoint.setEnabled(enabled);
    }

    protected void updateButtons() {
        this.waypointsListWidget.updateButtons();
    }
}

