/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils;

import de.hysky.skyblocker.utils.OkLabColor;
import net.minecraft.class_1767;
import net.minecraft.class_3532;
import net.minecraft.class_9848;

public class ColorUtils {
    public static float[] getFloatComponents(int color) {
        return new float[]{class_9848.method_65101((int)color), class_9848.method_65102((int)color), class_9848.method_65103((int)color)};
    }

    public static float[] getFloatComponents(class_1767 dye) {
        return ColorUtils.getFloatComponents(dye.method_7787());
    }

    public static int percentToColor(float pcnt) {
        return class_3532.method_15369((float)(pcnt / 300.0f), (float)1.0f, (float)1.0f);
    }

    public static int interpolate(int firstColor, int secondColor, double percentage) {
        return OkLabColor.interpolate(firstColor, secondColor, (float)percentage);
    }

    public static int interpolate(double percentage, int ... colors) {
        int colorCount = colors.length;
        if (colorCount == 0) {
            return 0;
        }
        if (colorCount == 1 || percentage <= 0.0) {
            return colors[0];
        }
        if (percentage >= 1.0) {
            return colors[colorCount - 1];
        }
        double scaledPercentage = percentage * (double)(colorCount - 1);
        int index = (int)Math.floor(scaledPercentage);
        double remainder = scaledPercentage - (double)index;
        return ColorUtils.interpolate(colors[index], colors[index + 1], remainder);
    }

    public static boolean isBright(int color) {
        double blackContrast;
        float blue;
        float green;
        float[] components = ColorUtils.getFloatComponents(color);
        float red = components[0];
        double luminance = ColorUtils.luminance(red, green = components[1], blue = components[2]);
        double whiteContrast = ColorUtils.contrastRatio(luminance, 1.0);
        return whiteContrast < (blackContrast = ColorUtils.contrastRatio(luminance, 0.0));
    }

    private static double luminance(float red, float green, float blue) {
        double r = red <= 0.04045f ? (double)(red / 12.92f) : Math.pow((red + 0.055f) / 1.055f, 2.4f);
        double g = green <= 0.04045f ? (double)(green / 12.92f) : Math.pow((green + 0.055f) / 1.055f, 2.4f);
        double b = blue <= 0.04045f ? (double)(blue / 12.92f) : Math.pow((blue + 0.055f) / 1.055f, 2.4f);
        return Math.fma(0.2126, r, Math.fma(0.7152, g, 0.0722 * b));
    }

    private static double contrastRatio(double background, double content) {
        double brightest = Math.max(background, content);
        double darkest = Math.min(background, content);
        return (brightest + 0.05) / (darkest + 0.05);
    }
}

