/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkyblockTime {
    private static final long SKYBLOCK_EPOCH = 1560275700000L;
    public static final AtomicInteger skyblockYear = new AtomicInteger(0);
    public static final AtomicReference<Season> skyblockSeason = new AtomicReference<Season>(Season.SPRING);
    public static final AtomicReference<Month> skyblockMonth = new AtomicReference<Month>(Month.EARLY_SPRING);
    public static final AtomicInteger skyblockDay = new AtomicInteger(0);
    public static final AtomicInteger skyblockHour = new AtomicInteger(0);
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Skyblocker Time");
    public static final double HOUR_LENGTH = 50000.0;
    public static final double DAY_LENGTH = 1200000.0;
    public static final double MONTH_LENGTH = 3.72E7;
    public static final double SEASON_LENGTH = 1.116E8;
    public static final double YEAR_LENGTH = 4.464E8;
    public static final Event<OnHourChange> HOUR_CHANGE = EventFactory.createArrayBacked(OnHourChange.class, listeners -> hour -> {
        for (OnHourChange listener : listeners) {
            listener.onHourChange(hour);
        }
    });
    public static final Event<OnDayChange> DAY_CHANGE = EventFactory.createArrayBacked(OnDayChange.class, listeners -> day -> {
        for (OnDayChange listener : listeners) {
            listener.onDayChange(day);
        }
    });
    public static final Event<OnMonthChange> MONTH_CHANGE = EventFactory.createArrayBacked(OnMonthChange.class, listeners -> month -> {
        for (OnMonthChange listener : listeners) {
            listener.onMonthChange(month);
        }
    });
    public static final Event<OnSeasonChange> SEASON_CHANGE = EventFactory.createArrayBacked(OnSeasonChange.class, listeners -> season -> {
        for (OnSeasonChange listener : listeners) {
            listener.onSeasonChange(season);
        }
    });
    public static final Event<OnYearChange> YEAR_CHANGE = EventFactory.createArrayBacked(OnYearChange.class, listeners -> year -> {
        for (OnYearChange listener : listeners) {
            listener.onYearChange(year);
        }
    });
    public static final Event<OnTimeUpdate> TIME_UPDATE = EventFactory.createArrayBacked(OnTimeUpdate.class, listeners -> (year, season, month, day, hour) -> {
        for (OnTimeUpdate listener : listeners) {
            listener.onTimeUpdate(year, season, month, day, hour);
        }
    });

    private SkyblockTime() {
    }

    @Init
    public static void init() {
        SkyblockTime.updateTime();
        Scheduler.INSTANCE.schedule(() -> Scheduler.INSTANCE.scheduleCyclic(SkyblockTime::updateTime, 1000), (int)(50000.0 - (double)SkyblockTime.getSkyblockMillis() % 50000.0) / 50);
    }

    public static long getSkyblockMillis() {
        return System.currentTimeMillis() - 1560275700000L;
    }

    private static int calculateSkyblockYear() {
        return (int)(Math.floor((double)SkyblockTime.getSkyblockMillis() / 4.464E8) + 1.0);
    }

    private static int calculateSkyblockMonth() {
        return (int)(Math.floor((double)SkyblockTime.getSkyblockMillis() / 3.72E7) % 12.0);
    }

    private static int calculateSkyblockDay() {
        return (int)(Math.floor((double)SkyblockTime.getSkyblockMillis() / 1200000.0) % 31.0 + 1.0);
    }

    private static int calculateSkyblockHour() {
        return (int)(Math.floor((double)SkyblockTime.getSkyblockMillis() / 50000.0) % 24.0);
    }

    private static void updateTime() {
        int year = SkyblockTime.calculateSkyblockYear();
        if (skyblockYear.get() != year) {
            skyblockYear.set(year);
            ((OnYearChange)YEAR_CHANGE.invoker()).onYearChange(year);
        }
        Season season = Season.values()[SkyblockTime.calculateSkyblockMonth() / 3];
        if (skyblockSeason.get() != season) {
            skyblockSeason.set(season);
            ((OnSeasonChange)SEASON_CHANGE.invoker()).onSeasonChange(season);
        }
        Month month = Month.values()[SkyblockTime.calculateSkyblockMonth()];
        if (skyblockMonth.get() != month) {
            skyblockMonth.set(month);
            ((OnMonthChange)MONTH_CHANGE.invoker()).onMonthChange(month);
        }
        int day = SkyblockTime.calculateSkyblockDay();
        if (skyblockDay.get() != day) {
            skyblockDay.set(day);
            ((OnDayChange)DAY_CHANGE.invoker()).onDayChange(day);
        }
        int hour = SkyblockTime.calculateSkyblockHour();
        if (skyblockHour.get() != hour) {
            skyblockHour.set(hour);
            ((OnHourChange)HOUR_CHANGE.invoker()).onHourChange(hour);
        }
        ((OnTimeUpdate)TIME_UPDATE.invoker()).onTimeUpdate(year, season, month, day, hour);
    }

    public static class_5250 formatTime(double seconds) {
        if (seconds <= 0.0) {
            return class_2561.method_43470((String)"Now").method_27692(class_124.field_1060);
        }
        return class_2561.method_43470((String)SkyblockTime.formatTimeString(seconds));
    }

    @NotNull
    public static String formatTimeString(double seconds) {
        seconds = Math.ceil(Math.max(seconds, 0.0));
        StringBuilder builder = new StringBuilder();
        if (seconds >= 86400.0) {
            builder.append((int)(seconds / 86400.0)).append("d ");
            seconds %= 86400.0;
        }
        if (seconds >= 3600.0) {
            builder.append((int)(seconds / 3600.0)).append("h ");
            seconds %= 3600.0;
        }
        if (seconds >= 60.0) {
            builder.append((int)(seconds / 60.0)).append("m ");
            seconds %= 60.0;
        }
        if (seconds >= 1.0) {
            builder.append((int)seconds).append("s");
        }
        return builder.toString().trim();
    }

    public static interface OnYearChange {
        public void onYearChange(int var1);
    }

    public static enum Season {
        SPRING,
        SUMMER,
        FALL,
        WINTER;

    }

    public static interface OnSeasonChange {
        public void onSeasonChange(Season var1);
    }

    public static enum Month {
        EARLY_SPRING,
        SPRING,
        LATE_SPRING,
        EARLY_SUMMER,
        SUMMER,
        LATE_SUMMER,
        EARLY_FALL,
        FALL,
        LATE_FALL,
        EARLY_WINTER,
        WINTER,
        LATE_WINTER;

    }

    public static interface OnMonthChange {
        public void onMonthChange(Month var1);
    }

    public static interface OnDayChange {
        public void onDayChange(int var1);
    }

    public static interface OnHourChange {
        public void onHourChange(int var1);
    }

    public static interface OnTimeUpdate {
        public void onTimeUpdate(int var1, Season var2, Month var3, int var4, int var5);
    }
}

