/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.data;

import com.mojang.serialization.Codec;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.data.JsonData;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_4844;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProfiledData<T>
extends JsonData<Object2ObjectOpenHashMap<UUID, Object2ObjectOpenHashMap<String, T>>> {
    public ProfiledData(@NotNull Path file, @NotNull Codec<T> codec) {
        this(file, codec, false);
    }

    public ProfiledData(@NotNull Path file, @NotNull Codec<T> codec, boolean compressed) {
        this(file, codec, compressed, true, false);
    }

    public ProfiledData(@NotNull Path file, @NotNull Codec<T> codec, boolean loadAsync, boolean saveAsync) {
        this(file, codec, false, loadAsync, saveAsync);
    }

    public ProfiledData(@NotNull Path file, @NotNull Codec<T> codec, boolean compressed, boolean loadAsync, boolean saveAsync) {
        super(file, Codec.unboundedMap((Codec)class_4844.field_40825, (Codec)Codec.unboundedMap((Codec)Codec.STRING, codec).xmap(Object2ObjectOpenHashMap::new, Function.identity())).xmap(Object2ObjectOpenHashMap::new, Function.identity()), new Object2ObjectOpenHashMap(), compressed, loadAsync, saveAsync);
    }

    public boolean containsKey() {
        return this.containsKey(Utils.getUuid(), Utils.getProfileId());
    }

    public boolean containsKey(@NotNull UUID uuid, @NotNull String profileId) {
        return this.getPlayerData(uuid).containsKey(profileId);
    }

    @Nullable
    public T get() {
        return this.get(Utils.getUuid(), Utils.getProfileId());
    }

    @Nullable
    public T get(@NotNull UUID uuid, @NotNull String profileId) {
        return this.getPlayerData(uuid).get(profileId);
    }

    @Nullable
    public T put(@NotNull T value) {
        return this.put(Utils.getUuid(), Utils.getProfileId(), value);
    }

    @Nullable
    public T put(@NotNull UUID uuid, @NotNull String profileId, @NotNull T value) {
        return this.getPlayerData(uuid).put(profileId, value);
    }

    @Nullable
    public T putIfAbsent(@NotNull T value) {
        return this.putIfAbsent(Utils.getUuid(), Utils.getProfileId(), value);
    }

    @Nullable
    public T putIfAbsent(@NotNull UUID uuid, @NotNull String profileId, @NotNull T value) {
        return this.getPlayerData(uuid).putIfAbsent(profileId, value);
    }

    @Nullable
    public T computeIfAbsent(@NotNull Supplier<T> valueSupplier) {
        return this.computeIfAbsent(Utils.getUuid(), Utils.getProfileId(), valueSupplier);
    }

    @Nullable
    public T computeIfAbsent(@NotNull UUID uuid, @NotNull String profileId, @NotNull Supplier<T> valueSupplier) {
        return (T)this.getPlayerData(uuid).computeIfAbsent(profileId, _profileId -> valueSupplier.get());
    }

    @Nullable
    public T remove() {
        return this.remove(Utils.getUuid(), Utils.getProfileId());
    }

    @Nullable
    public T remove(@NotNull UUID uuid, @NotNull String profileId) {
        return this.getPlayerData(uuid).remove(profileId);
    }

    @NotNull
    private Map<String, T> getPlayerData(@NotNull UUID uuid) {
        return (Map)((Object2ObjectOpenHashMap)this.getData()).computeIfAbsent((Object)uuid, _uuid -> new Object2ObjectOpenHashMap());
    }
}

