/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.render;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.class_11285;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.system.MemoryUtil;

public class Renderer {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final List<RenderPipeline> EXCLUDED_FROM_BATCHING = new ArrayList<RenderPipeline>();
    private static final class_9799 GENERAL_ALLOCATOR = new class_9799(786432);
    private static final float DEFAULT_LINE_WIDTH = 0.0f;
    private static final Vector4f COLOR_MODULATOR = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    private static final Int2ObjectMap<class_9799> ALLOCATORS = new Int2ObjectArrayMap(5);
    private static final Int2ObjectMap<BatchedDraw> BATCHED_DRAWS = new Int2ObjectArrayMap(5);
    private static final Map<VertexFormat, class_11285> VERTEX_BUFFERS = new Object2ObjectOpenHashMap();
    private static final List<PreparedDraw> PREPARED_DRAWS = new ArrayList<PreparedDraw>();
    private static final List<Draw> DRAWS = new ArrayList<Draw>();
    private static BatchedDraw lastUnbatchedDraw = null;

    protected static class_287 getBuffer(RenderPipeline pipeline) {
        return Renderer.getBuffer(pipeline, null, 0.0f);
    }

    protected static class_287 getBuffer(RenderPipeline pipeline, GpuTextureView textureView) {
        return Renderer.getBuffer(pipeline, Objects.requireNonNull(textureView, "textureView must not be null"), 0.0f);
    }

    protected static class_287 getBuffer(RenderPipeline pipeline, float lineWidth) {
        return Renderer.getBuffer(pipeline, null, lineWidth);
    }

    private static class_287 getBuffer(RenderPipeline pipeline, @Nullable GpuTextureView textureView, float lineWidth) {
        if (!EXCLUDED_FROM_BATCHING.contains(pipeline)) {
            return Renderer.setupBatched(pipeline, textureView, lineWidth);
        }
        return Renderer.setupUnbatched(pipeline, textureView, lineWidth);
    }

    private static class_287 setupBatched(RenderPipeline pipeline, @Nullable GpuTextureView textureView, float lineWidth) {
        int hash = Renderer.hash(pipeline, textureView, lineWidth);
        BatchedDraw draw = (BatchedDraw)BATCHED_DRAWS.get(hash);
        if (draw == null) {
            class_9799 allocator = (class_9799)ALLOCATORS.computeIfAbsent(hash, _hash -> new class_9799(786432));
            class_287 bufferBuilder = new class_287(allocator, pipeline.getVertexFormatMode(), pipeline.getVertexFormat());
            BATCHED_DRAWS.put(hash, (Object)new BatchedDraw(bufferBuilder, pipeline, textureView, lineWidth));
            return bufferBuilder;
        }
        return draw.bufferBuilder();
    }

    private static class_287 setupUnbatched(RenderPipeline pipeline, @Nullable GpuTextureView textureView, float lineWidth) {
        if (lastUnbatchedDraw != null) {
            Renderer.prepareBatchedDraw(lastUnbatchedDraw);
        }
        class_287 bufferBuilder = new class_287(GENERAL_ALLOCATOR, pipeline.getVertexFormatMode(), pipeline.getVertexFormat());
        lastUnbatchedDraw = new BatchedDraw(bufferBuilder, pipeline, textureView, lineWidth);
        return bufferBuilder;
    }

    private static int hash(RenderPipeline pipeline, @Nullable GpuTextureView textureView, float lineWidth) {
        int hash = 1;
        hash = 31 * hash + pipeline.hashCode();
        hash = 31 * hash + Objects.hashCode(textureView);
        hash = 31 * hash + Float.hashCode(lineWidth);
        return hash;
    }

    protected static void excludePipelineFromBatching(RenderPipeline pipeline) {
        EXCLUDED_FROM_BATCHING.add(pipeline);
    }

    private static void endBatches() {
        for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(BATCHED_DRAWS)) {
            Renderer.prepareBatchedDraw((BatchedDraw)entry.getValue());
        }
        if (lastUnbatchedDraw != null) {
            Renderer.prepareBatchedDraw(lastUnbatchedDraw);
            lastUnbatchedDraw = null;
        }
    }

    private static void prepareBatchedDraw(BatchedDraw draw) {
        PREPARED_DRAWS.add(new PreparedDraw(draw.bufferBuilder().method_60800(), draw.pipeline(), draw.textureView(), draw.lineWidth()));
    }

    protected static void executeDraws() {
        Renderer.endBatches();
        Renderer.setupDraws();
        for (Draw draw : DRAWS) {
            Renderer.draw(draw);
        }
        for (class_11285 buffer : VERTEX_BUFFERS.values()) {
            buffer.method_71121();
        }
        BATCHED_DRAWS.clear();
        PREPARED_DRAWS.clear();
        DRAWS.clear();
    }

    private static void setupDraws() {
        Renderer.setupVertexBuffers();
        Object2IntOpenHashMap vertexBufferPositions = new Object2IntOpenHashMap();
        for (PreparedDraw prepared : PREPARED_DRAWS) {
            class_9801 builtBuffer = prepared.builtBuffer();
            class_9801.class_4574 drawParameters = builtBuffer.method_60822();
            VertexFormat format = drawParameters.comp_749();
            class_11285 vertices = VERTEX_BUFFERS.get(format);
            ByteBuffer vertexData = builtBuffer.method_60818();
            int vertexBufferPosition = vertexBufferPositions.getInt((Object)format);
            int remainingVertexBytes = vertexData.remaining();
            Renderer.copyDataInto(vertices, vertexData, vertexBufferPosition, remainingVertexBytes);
            vertexBufferPositions.put((Object)format, vertexBufferPosition + remainingVertexBytes);
            DRAWS.add(new Draw(builtBuffer, vertices.method_71119(), vertexBufferPosition / format.getVertexSize(), drawParameters.comp_751(), prepared.pipeline(), prepared.textureView(), prepared.lineWidth()));
        }
    }

    private static void copyDataInto(class_11285 target, ByteBuffer source, int position, int remainingBytes) {
        CommandEncoder commandEncoder = RenderSystem.getDevice().createCommandEncoder();
        try (GpuBuffer.MappedView mappedView = commandEncoder.mapBuffer(target.method_71119().slice(position, remainingBytes), false, true);){
            MemoryUtil.memCopy((ByteBuffer)source, (ByteBuffer)mappedView.data());
        }
    }

    private static void setupVertexBuffers() {
        Object2IntMap<VertexFormat> vertexBufferSizes = Renderer.collectVertexBufferSizes();
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(vertexBufferSizes)) {
            VertexFormat format = (VertexFormat)entry.getKey();
            int vertexBufferSize = entry.getIntValue();
            class_11285 vertexBuffer = VERTEX_BUFFERS.get(format);
            VERTEX_BUFFERS.put(format, Renderer.initOrResizeBuffer(vertexBuffer, "Skyblocker vertex buffer for: " + String.valueOf(format), vertexBufferSize, 32));
        }
    }

    private static class_11285 initOrResizeBuffer(class_11285 buffer, String name, int neededSize, int usageType) {
        if (buffer == null || buffer.method_71312() < neededSize) {
            if (buffer != null) {
                buffer.close();
            }
            return new class_11285(() -> name, 2 | usageType, neededSize);
        }
        return buffer;
    }

    private static Object2IntMap<VertexFormat> collectVertexBufferSizes() {
        Object2IntOpenHashMap vertexSizes = new Object2IntOpenHashMap();
        for (PreparedDraw prepared : PREPARED_DRAWS) {
            class_9801.class_4574 drawParameters = prepared.builtBuffer().method_60822();
            VertexFormat format = drawParameters.comp_749();
            vertexSizes.put((Object)format, vertexSizes.getOrDefault((Object)format, 0) + drawParameters.comp_750() * format.getVertexSize());
        }
        return vertexSizes;
    }

    private static void draw(Draw draw) {
        VertexFormat.class_5595 indexType;
        GpuBuffer indices;
        if (draw.pipeline().getVertexFormatMode() == VertexFormat.class_5596.field_27382) {
            draw.builtBuffer().method_60819(GENERAL_ALLOCATOR, RenderSystem.getProjectionType().method_65045());
            indices = draw.pipeline().getVertexFormat().uploadImmediateIndexBuffer(draw.builtBuffer().method_60821());
            indexType = draw.builtBuffer().method_60822().comp_753();
        } else {
            RenderSystem.class_5590 shapeIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)draw.pipeline().getVertexFormatMode());
            indices = shapeIndexBuffer.method_68274(draw.indexCount());
            indexType = shapeIndexBuffer.method_31924();
        }
        Renderer.draw(draw, indices, indexType);
    }

    private static void draw(Draw draw, GpuBuffer indices, VertexFormat.class_5595 indexType) {
        Renderer.applyViewOffsetZLayering();
        GpuBufferSlice dynamicTransforms = Renderer.setupDynamicTransforms(draw.lineWidth);
        try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "skyblocker world rendering", Renderer.getMainColorTexture(), OptionalInt.empty(), Renderer.getMainDepthTexture(), OptionalDouble.empty());){
            renderPass.setPipeline(draw.pipeline);
            RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
            renderPass.setUniform("DynamicTransforms", dynamicTransforms);
            if (draw.textureView != null) {
                renderPass.bindSampler("Sampler0", draw.textureView);
            }
            renderPass.setVertexBuffer(0, draw.vertices);
            renderPass.setIndexBuffer(indices, indexType);
            renderPass.drawIndexed(draw.baseVertex, 0, draw.indexCount, 1);
        }
        draw.builtBuffer().close();
        Renderer.unapplyViewOffsetZLayering();
    }

    private static GpuBufferSlice setupDynamicTransforms(float lineWidth) {
        GpuBufferSlice dynamicTransforms = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)COLOR_MODULATOR, (Vector3fc)RenderSystem.getModelOffset(), (Matrix4fc)RenderSystem.getTextureMatrix(), lineWidth);
        return dynamicTransforms;
    }

    private static GpuTextureView getMainColorTexture() {
        return CLIENT.method_1522().method_71639();
    }

    private static GpuTextureView getMainDepthTexture() {
        return CLIENT.method_1522().method_71640();
    }

    private static void applyViewOffsetZLayering() {
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        RenderSystem.getProjectionType().method_65046((Matrix4f)modelViewStack, 1.0f);
    }

    private static void unapplyViewOffsetZLayering() {
        RenderSystem.getModelViewStack().popMatrix();
    }

    public static void close() {
        GENERAL_ALLOCATOR.close();
        for (class_9799 allocator : ALLOCATORS.values()) {
            allocator.close();
        }
        for (class_11285 vertexBuffer : VERTEX_BUFFERS.values()) {
            vertexBuffer.close();
        }
    }

    private record BatchedDraw(class_287 bufferBuilder, RenderPipeline pipeline, @Nullable GpuTextureView textureView, float lineWidth) {
    }

    private record PreparedDraw(class_9801 builtBuffer, RenderPipeline pipeline, @Nullable GpuTextureView textureView, float lineWidth) {
    }

    private record Draw(class_9801 builtBuffer, GpuBuffer vertices, int baseVertex, int indexCount, RenderPipeline pipeline, @Nullable GpuTextureView textureView, float lineWidth) {
    }
}

