/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.render.title;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.UIAndVisualsConfig;
import de.hysky.skyblocker.utils.render.title.Title;
import de.hysky.skyblocker.utils.render.title.TitleContainerConfigScreen;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import net.minecraft.class_9779;

public class TitleContainer {
    private static final class_2960 TITLE_CONTAINER = class_2960.method_60655((String)"skyblocker", (String)"title_container");
    private static final class_310 CLIENT = class_310.method_1551();
    private static final Set<Title> titles = new LinkedHashSet<Title>();

    @Init
    public static void init() {
        HudElementRegistry.attachElementAfter((class_2960)VanillaHudElements.TITLE_AND_SUBTITLE, (class_2960)TITLE_CONTAINER, TitleContainer::render);
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"hud").then(ClientCommandManager.literal((String)"titleContainer").executes(Scheduler.queueOpenScreenCommand(TitleContainerConfigScreen::new))))));
    }

    public static boolean containsTitle(Title title) {
        return titles.contains(title);
    }

    public static boolean addTitle(Title title) {
        if (titles.add(title)) {
            title.resetPos();
            return true;
        }
        return false;
    }

    public static boolean addTitle(Title title, int ticks) {
        if (TitleContainer.addTitle(title)) {
            Scheduler.INSTANCE.schedule(() -> TitleContainer.removeTitle(title), ticks);
            return true;
        }
        return false;
    }

    public static boolean addTitleAndPlaySound(Title title) {
        if (TitleContainer.addTitle(title)) {
            TitleContainer.playNotificationSound();
            return true;
        }
        return false;
    }

    public static boolean addTitleAndPlaySound(Title title, int ticks) {
        if (TitleContainer.addTitle(title, ticks)) {
            TitleContainer.playNotificationSound();
            return true;
        }
        return false;
    }

    public static void playNotificationSound() {
        if (TitleContainer.CLIENT.field_1724 != null) {
            TitleContainer.CLIENT.field_1724.method_5783(class_3417.field_14627, 100.0f, 0.1f);
        }
    }

    public static void removeTitle(Title title) {
        titles.remove(title);
    }

    private static void render(class_332 context, class_9779 tickCounter) {
        TitleContainer.render(context, titles, SkyblockerConfigManager.get().uiAndVisuals.titleContainer.x, SkyblockerConfigManager.get().uiAndVisuals.titleContainer.y, tickCounter.method_60637(true));
    }

    protected static void render(class_332 context, Set<Title> titles, int xPos, int yPos, float tickDelta) {
        if (titles.isEmpty()) {
            return;
        }
        class_327 textRenderer = class_310.method_1551().field_1772;
        float scale = SkyblockerConfigManager.get().uiAndVisuals.titleContainer.getRenderScale();
        UIAndVisualsConfig.Direction direction = SkyblockerConfigManager.get().uiAndVisuals.titleContainer.direction;
        UIAndVisualsConfig.Alignment alignment = SkyblockerConfigManager.get().uiAndVisuals.titleContainer.alignment;
        float x = xPos >= 0 ? (float)xPos : (float)class_310.method_1551().method_22683().method_4486() / 2.0f;
        float y = yPos >= 0 ? (float)yPos : (float)class_310.method_1551().method_22683().method_4502() * 0.6f;
        float totalWidth = TitleContainer.getWidth(textRenderer, titles);
        if (alignment == UIAndVisualsConfig.Alignment.MIDDLE && direction == UIAndVisualsConfig.Direction.HORIZONTAL) {
            x = (float)xPos - totalWidth / 2.0f;
        }
        for (Title title : titles) {
            float xTextLeft = x;
            if (alignment == UIAndVisualsConfig.Alignment.RIGHT) {
                xTextLeft = x - (float)textRenderer.method_27525((class_5348)title.getText()) * scale;
            } else if (direction == UIAndVisualsConfig.Direction.VERTICAL && alignment == UIAndVisualsConfig.Alignment.MIDDLE) {
                xTextLeft = x - (float)textRenderer.method_27525((class_5348)title.getText()) * scale / 2.0f;
            }
            if (title.isDefaultPos()) {
                title.x = xTextLeft;
                title.y = y;
            }
            title.x = class_3532.method_16439((float)(tickDelta * 0.5f), (float)title.x, (float)xTextLeft);
            title.y = class_3532.method_16439((float)(tickDelta * 0.5f), (float)title.y, (float)y);
            context.method_51448().pushMatrix();
            context.method_51448().translate(title.x, title.y);
            context.method_51448().scale(scale, scale);
            context.method_27535(textRenderer, (class_2561)title.getText(), 0, 0, -1);
            context.method_51448().popMatrix();
            if (direction == UIAndVisualsConfig.Direction.HORIZONTAL) {
                if (alignment == UIAndVisualsConfig.Alignment.MIDDLE || alignment == UIAndVisualsConfig.Alignment.LEFT) {
                    x += (float)(textRenderer.method_27525((class_5348)title.getText()) + 10) * scale;
                    continue;
                }
                if (alignment != UIAndVisualsConfig.Alignment.RIGHT) continue;
                x -= (float)(textRenderer.method_27525((class_5348)title.getText()) + 10) * scale;
                continue;
            }
            Objects.requireNonNull(textRenderer);
            y += (float)(9 + 1) * scale;
        }
    }

    protected static int getWidth(class_327 textRenderer, Set<Title> titles) {
        float scale = SkyblockerConfigManager.get().uiAndVisuals.titleContainer.getRenderScale();
        return SkyblockerConfigManager.get().uiAndVisuals.titleContainer.direction == UIAndVisualsConfig.Direction.HORIZONTAL ? (int)((titles.stream().map(Title::getText).mapToInt(arg_0 -> ((class_327)textRenderer).method_27525(arg_0)).mapToDouble(width -> width + 10).sum() - 10.0) * (double)scale) : (int)((float)titles.stream().map(Title::getText).mapToInt(arg_0 -> ((class_327)textRenderer).method_27525(arg_0)).max().orElse(0) * scale);
    }

    protected static int getHeight(class_327 textRenderer, Set<Title> titles) {
        int n;
        float scale = SkyblockerConfigManager.get().uiAndVisuals.titleContainer.getRenderScale();
        if (SkyblockerConfigManager.get().uiAndVisuals.titleContainer.direction == UIAndVisualsConfig.Direction.HORIZONTAL) {
            Objects.requireNonNull(textRenderer);
            n = (int)(9.0f * scale);
        } else {
            Objects.requireNonNull(textRenderer);
            n = (int)((float)((9 + 1) * titles.size()) * scale);
        }
        return n;
    }
}

