/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.scheduler;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import it.unimi.dsi.fastutil.ints.AbstractInt2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_10209;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scheduler {
    protected static final Logger LOGGER = LoggerFactory.getLogger(Scheduler.class);
    public static final Scheduler INSTANCE = new Scheduler();
    private int currentTick = 0;
    private final AbstractInt2ObjectMap<List<Runnable>> tasks = new Int2ObjectOpenHashMap();
    private final ExecutorService executors = ForkJoinPool.commonPool();

    protected Scheduler() {
    }

    public void schedule(Runnable task, int delay) {
        this.schedule(task, delay, false);
    }

    public void scheduleCyclic(Runnable task, int period) {
        this.scheduleCyclic(task, period, false);
    }

    public void schedule(Runnable task, int delay, boolean multithreaded) {
        if (!RenderSystem.isOnRenderThread() && class_310.method_1551() != null) {
            LOGGER.warn("[Skyblocker Scheduler] Called the scheduler from the {} class on the {} thread. This will be unsupported in the future.", (Object)StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass().getName(), (Object)Thread.currentThread().getName());
            class_310.method_1551().method_63588(() -> this.schedule(task, delay, multithreaded));
            return;
        }
        if (delay >= 0) {
            this.addTask(multithreaded ? new ScheduledTask(task, true) : task, this.currentTick + delay);
        } else {
            LOGGER.warn("Scheduled a task with negative delay");
        }
    }

    public void scheduleCyclic(Runnable task, int period, boolean multithreaded) {
        if (!RenderSystem.isOnRenderThread() && class_310.method_1551() != null) {
            LOGGER.warn("[Skyblocker Scheduler] Called the scheduler from the {} class on the {} thread. This will be unsupported in the future.", (Object)StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass().getName(), (Object)Thread.currentThread().getName());
            class_310.method_1551().method_63588(() -> this.scheduleCyclic(task, period, multithreaded));
            return;
        }
        if (period > 0) {
            this.addTask(new ScheduledTask(task, period, true, multithreaded), this.currentTick);
        } else {
            LOGGER.error("Attempted to schedule a cyclic task with period lower than 1");
        }
    }

    public static Command<FabricClientCommandSource> queueOpenScreenFactoryCommand(Function<CommandContext<FabricClientCommandSource>, class_437> screenFactory) {
        return context -> Scheduler.queueOpenScreen((class_437)screenFactory.apply(context));
    }

    public static Command<FabricClientCommandSource> queueOpenScreenCommand(Supplier<class_437> screenSupplier) {
        return context -> Scheduler.queueOpenScreen((class_437)screenSupplier.get());
    }

    public static Command<FabricClientCommandSource> queueOpenScreenCommand(class_437 screen) {
        return context -> Scheduler.queueOpenScreen(screen);
    }

    @Deprecated(forRemoval=true)
    public static int queueOpenScreen(Supplier<class_437> screenSupplier) {
        return Scheduler.queueOpenScreen(screenSupplier.get());
    }

    public static int queueOpenScreen(class_437 screen) {
        class_310.method_1551().method_63588(() -> class_310.method_1551().method_1507(screen));
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    public void tick() {
        block3: {
            profiler = class_10209.method_64146();
            profiler.method_15396("skyblockerSchedulerTick");
            if (!this.tasks.containsKey(this.currentTick)) break block3;
            currentTickTasks = (List)this.tasks.get(this.currentTick);
            for (i = 0; i < currentTickTasks.size(); ++i) {
                task = (Runnable)currentTickTasks.get(i);
                if (!(task instanceof ScheduledTask)) ** GOTO lbl-1000
                scheduledTask = (ScheduledTask)task;
                if (scheduledTask.multithreaded) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                if (this.runTask(task, v0)) continue;
                ((List)this.tasks.computeIfAbsent(this.currentTick + 1, (Int2ObjectFunction)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$tick$6(int ), (I)Ljava/util/List;)())).add(task);
            }
            this.tasks.remove(this.currentTick);
        }
        ++this.currentTick;
        profiler.method_15407();
    }

    protected boolean runTask(Runnable task, boolean multithreaded) {
        if (multithreaded) {
            this.executors.execute(task);
        } else {
            task.run();
        }
        return true;
    }

    private void addTask(Runnable task, int schedule) {
        if (this.tasks.containsKey(schedule)) {
            ((List)this.tasks.get(schedule)).add(task);
        } else {
            ArrayList<Runnable> list = new ArrayList<Runnable>();
            list.add(task);
            this.tasks.put(schedule, list);
        }
    }

    private static /* synthetic */ List lambda$tick$6(int key) {
        return new ArrayList();
    }

    protected record ScheduledTask(Runnable task, int interval, boolean cyclic, boolean multithreaded) implements Runnable
    {
        private ScheduledTask(Runnable task, boolean multithreaded) {
            this(task, -1, false, multithreaded);
        }

        @Override
        public void run() {
            this.task.run();
            if (this.cyclic) {
                if (!RenderSystem.isOnRenderThread() && class_310.method_1551() != null) {
                    class_310.method_1551().method_63588(() -> INSTANCE.addTask(this, Scheduler.INSTANCE.currentTick + this.interval));
                } else {
                    INSTANCE.addTask(this, Scheduler.INSTANCE.currentTick + this.interval);
                }
            }
        }
    }
}

