/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.waypoint;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.waypoint.NamedWaypoint;
import de.hysky.skyblocker.utils.waypoint.OrderedNamedWaypoint;
import de.hysky.skyblocker.utils.waypoint.Waypoint;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_310;

public class WaypointGroup {
    public static final Codec<WaypointGroup> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(WaypointGroup::name), (App)Codec.STRING.fieldOf("island").xmap(Location::from, Location::id).forGetter(WaypointGroup::island), (App)NamedWaypoint.CODEC.listOf().fieldOf("waypoints").forGetter(WaypointGroup::waypoints), (App)Codec.BOOL.lenientOptionalFieldOf("ordered", (Object)false).forGetter(WaypointGroup::ordered)).apply((Applicative)instance, WaypointGroup::new));
    public static final Codec<WaypointGroup> SKYTILS_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(WaypointGroup::name), (App)Codec.STRING.fieldOf("island").xmap(Location::from, Location::id).forGetter(WaypointGroup::island), (App)NamedWaypoint.SKYTILS_CODEC.listOf().fieldOf("waypoints").forGetter(WaypointGroup::waypoints)).apply((Applicative)instance, WaypointGroup::new));
    public static final Codec<WaypointGroup> COLEWEIGHT_CODEC = NamedWaypoint.COLEWEIGHT_CODEC.listOf().xmap(coleWeightWaypoints -> new WaypointGroup("Coleweight", Location.UNKNOWN, (List<NamedWaypoint>)coleWeightWaypoints, true), WaypointGroup::waypoints);
    public static final Codec<WaypointGroup> SKYBLOCKER_LEGACY_ORDERED_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(WaypointGroup::name), (App)Codec.BOOL.fieldOf("enabled").forGetter(group -> !group.waypoints().isEmpty() && group.waypoints().stream().allMatch(Waypoint::isEnabled)), (App)NamedWaypoint.SKYBLOCKER_LEGACY_ORDERED_CODEC.listOf().fieldOf("waypoints").forGetter(WaypointGroup::waypoints)).apply((Applicative)instance, (name, enabled, waypoints) -> {
        waypoints.forEach(enabled != false ? Waypoint::setMissing : Waypoint::setFound);
        return new WaypointGroup((String)name, Location.UNKNOWN, (List<NamedWaypoint>)waypoints, true);
    }));
    public static final int WAYPOINT_ACTIVATION_RADIUS = 2;
    private final String name;
    private final Location island;
    private final List<NamedWaypoint> waypoints;
    private final boolean ordered;
    private transient int currentIndex = 0;

    public WaypointGroup(String name, Location island, List<NamedWaypoint> waypoints) {
        this(name, island, waypoints, false);
    }

    public WaypointGroup(String name, Location island, List<NamedWaypoint> waypoints, boolean ordered) {
        this.name = name;
        this.island = island;
        this.ordered = ordered;
        this.waypoints = waypoints.stream().map(this::convertWaypoint).collect(Collectors.toList());
    }

    public String name() {
        return this.name;
    }

    public Location island() {
        return this.island;
    }

    public List<NamedWaypoint> waypoints() {
        return this.waypoints;
    }

    public boolean ordered() {
        return this.ordered;
    }

    public int currentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int currentIndex) {
        this.currentIndex = currentIndex;
    }

    public void resetCurrentIndex() {
        this.setCurrentIndex(0);
    }

    public WaypointGroup withName(String name) {
        return new WaypointGroup(name, this.island, this.waypoints, this.ordered);
    }

    public WaypointGroup withIsland(Location island) {
        return new WaypointGroup(this.name, island, this.waypoints, this.ordered);
    }

    public WaypointGroup withOrdered(boolean ordered) {
        return new WaypointGroup(this.name, this.island, this.waypoints, ordered);
    }

    public WaypointGroup filterWaypoints(Predicate<NamedWaypoint> predicate) {
        return new WaypointGroup(this.name, this.island, this.waypoints.stream().filter(predicate).toList(), this.ordered);
    }

    public WaypointGroup sortWaypoints(Comparator<NamedWaypoint> comparator) {
        return new WaypointGroup(this.name, this.island, this.waypoints.stream().sorted(comparator).toList(), this.ordered);
    }

    public WaypointGroup deepCopy() {
        return new WaypointGroup(this.name, this.island, this.waypoints.stream().map(NamedWaypoint::copy).collect(Collectors.toList()), this.ordered);
    }

    public NamedWaypoint createWaypoint(class_2338 pos) {
        String name = "Waypoint " + (this.waypoints.size() + 1);
        return this.ordered ? new OrderedNamedWaypoint(pos, name, new float[]{0.0f, 1.0f, 0.0f}) : new NamedWaypoint(pos, name, new float[]{0.0f, 1.0f, 0.0f});
    }

    public NamedWaypoint convertWaypoint(NamedWaypoint waypoint) {
        if (this.ordered) {
            return waypoint instanceof OrderedNamedWaypoint ? waypoint : new OrderedNamedWaypoint(waypoint);
        }
        return waypoint instanceof OrderedNamedWaypoint ? new NamedWaypoint(waypoint) : waypoint;
    }

    public void render(WorldRenderContext context) {
        if (this.ordered && !this.waypoints.isEmpty()) {
            for (int i = 0; i < this.waypoints.size(); ++i) {
                NamedWaypoint waypoint = this.waypoints.get(i);
                if (!waypoint.pos.method_19769((class_2374)class_310.method_1551().field_1724.method_19538(), 2.0)) continue;
                this.currentIndex = i;
            }
            int previousIndex = (this.currentIndex - 1 + this.waypoints.size()) % this.waypoints.size();
            int nextIndex = (this.currentIndex + 1) % this.waypoints.size();
            for (int i = 0; i < this.waypoints.size(); ++i) {
                NamedWaypoint waypoint = this.waypoints.get(i);
                if (!(waypoint instanceof OrderedNamedWaypoint)) continue;
                OrderedNamedWaypoint orderedNamedWaypoint = (OrderedNamedWaypoint)waypoint;
                orderedNamedWaypoint.index = i;
                orderedNamedWaypoint.relativeIndex = i == previousIndex ? OrderedNamedWaypoint.RelativeIndex.PREVIOUS : (i == nextIndex ? OrderedNamedWaypoint.RelativeIndex.NEXT : (i == this.currentIndex ? OrderedNamedWaypoint.RelativeIndex.CURRENT : OrderedNamedWaypoint.RelativeIndex.NONE));
            }
        }
        for (NamedWaypoint waypoint : this.waypoints) {
            if (!waypoint.shouldRender()) continue;
            waypoint.render(context);
        }
    }

    public boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{WaypointGroup.class, "name;island;waypoints;ordered", "name", "island", "waypoints", "ordered"}, this, object);
    }

    public int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{WaypointGroup.class, "name;island;waypoints;ordered", "name", "island", "waypoints", "ordered"}, this);
    }

    public String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{WaypointGroup.class, "name;island;waypoints;ordered", "name", "island", "waypoints", "ordered"}, this);
    }
}

